/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.zzdd;
import com.google.android.gms.internal.zzbfr;
import com.google.android.gms.internal.zzely;
import com.google.android.gms.internal.zzema;
import com.google.android.gms.internal.zzemg;
import com.google.android.gms.internal.zzemi;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.dynamiclinks.DynamicLink;
import com.google.firebase.dynamiclinks.FirebaseDynamicLinks;
import com.google.firebase.dynamiclinks.PendingDynamicLinkData;
import com.google.firebase.dynamiclinks.ShortDynamicLink;

public final class zzemd
extends FirebaseDynamicLinks {
    private final GoogleApi<Api.ApiOptions.NoOptions> zzfur;

    public zzemd(@NonNull Context context) {
        this(new zzema(context));
    }

    private zzemd(@NonNull GoogleApi<Api.ApiOptions.NoOptions> googleApi) {
        this.zzfur = googleApi;
    }

    private final void zzcbo() {
        try {
            AppMeasurement.getInstance((Context)this.zzfur.getApplicationContext());
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Log.w((String)"FDL", (String)"FDL logging failed. Add a dependency for Firebase Analytics to your app to enable logging of Dynamic Link events.");
            return;
        }
    }

    @Override
    public final Task<PendingDynamicLinkData> getDynamicLink(@NonNull Intent intent) {
        this.zzcbo();
        Task task = this.zzfur.zzb((zzdd)new zzemi(this.zzfur.getApplicationContext(), intent.getDataString()));
        zzely zzely2 = (zzely)zzbfr.zza((Intent)intent, (String)"com.google.firebase.dynamiclinks.DYNAMIC_LINK_DATA", zzely.CREATOR);
        PendingDynamicLinkData pendingDynamicLinkData = zzely2 != null ? new PendingDynamicLinkData(zzely2) : null;
        if (pendingDynamicLinkData != null) {
            task = Tasks.forResult((Object)pendingDynamicLinkData);
        }
        return task;
    }

    @Override
    public final Task<PendingDynamicLinkData> getDynamicLink(@NonNull Uri uri) {
        this.zzcbo();
        return this.zzfur.zzb((zzdd)new zzemi(this.zzfur.getApplicationContext(), uri.toString()));
    }

    @Override
    public final DynamicLink.Builder createDynamicLink() {
        return new DynamicLink.Builder(this);
    }

    public final Task<ShortDynamicLink> zzaa(Bundle bundle) {
        zzemd.zzab(bundle);
        return this.zzfur.zzb((zzdd)new zzemg(bundle));
    }

    public static void zzab(Bundle bundle) {
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (TextUtils.isEmpty((CharSequence)bundle.getString("domain")) && uri == null) {
            throw new IllegalArgumentException("FDL domain is missing. Set with setDynamicLinkDomain().");
        }
    }
}

