/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzemd;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zznfs;

    DynamicLink(Bundle bundle) {
        this.zznfs = bundle;
    }

    public final Uri getUri() {
        Bundle bundle = this.zznfs;
        zzemd.zzab(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            builder.scheme("https");
            builder.authority(bundle.getString("domain"));
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class NavigationInfoParameters {
        final Bundle zzeac;

        private NavigationInfoParameters(Bundle bundle) {
            this.zzeac = bundle;
        }

        /* synthetic */ NavigationInfoParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzeac = new Bundle();

            public Builder() {
            }

            public final Builder setForcedRedirectEnabled(boolean bl) {
                this.zzeac.putInt("efr", bl ? 1 : 0);
                return this;
            }

            public final NavigationInfoParameters build() {
                return new NavigationInfoParameters(this.zzeac, null);
            }
        }
    }

    public static final class SocialMetaTagParameters {
        final Bundle zzeac;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zzeac = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzeac = new Bundle();

            public Builder() {
            }

            public final Builder setTitle(String string) {
                this.zzeac.putString("st", string);
                return this;
            }

            public final Builder setDescription(String string) {
                this.zzeac.putString("sd", string);
                return this;
            }

            public final Builder setImageUrl(Uri uri) {
                this.zzeac.putParcelable("si", (Parcelable)uri);
                return this;
            }

            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zzeac, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zzeac;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zzeac = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzeac = new Bundle();

            public Builder() {
            }

            public final Builder setProviderToken(String string) {
                this.zzeac.putString("pt", string);
                return this;
            }

            public final Builder setAffiliateToken(String string) {
                this.zzeac.putString("at", string);
                return this;
            }

            public final Builder setCampaignToken(String string) {
                this.zzeac.putString("ct", string);
                return this;
            }

            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zzeac, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zzeac;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zzeac = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzeac = new Bundle();

            public Builder() {
            }

            public Builder(String string, String string2, String string3) {
                this.zzeac.putString("utm_source", string);
                this.zzeac.putString("utm_medium", string2);
                this.zzeac.putString("utm_campaign", string3);
            }

            public final Builder setSource(String string) {
                this.zzeac.putString("utm_source", string);
                return this;
            }

            public final Builder setMedium(String string) {
                this.zzeac.putString("utm_medium", string);
                return this;
            }

            public final Builder setCampaign(String string) {
                this.zzeac.putString("utm_campaign", string);
                return this;
            }

            public final Builder setTerm(String string) {
                this.zzeac.putString("utm_term", string);
                return this;
            }

            public final Builder setContent(String string) {
                this.zzeac.putString("utm_content", string);
                return this;
            }

            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zzeac, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zzeac;

        private IosParameters(Bundle bundle) {
            this.zzeac = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzeac = new Bundle();

            public Builder(@NonNull String string) {
                this.zzeac.putString("ibi", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzeac.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            public final Builder setCustomScheme(String string) {
                this.zzeac.putString("ius", string);
                return this;
            }

            public final Builder setIpadFallbackUrl(Uri uri) {
                this.zzeac.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            public final Builder setIpadBundleId(String string) {
                this.zzeac.putString("ipbi", string);
                return this;
            }

            public final Builder setAppStoreId(String string) {
                this.zzeac.putString("isi", string);
                return this;
            }

            public final Builder setMinimumVersion(String string) {
                this.zzeac.putString("imv", string);
                return this;
            }

            public final IosParameters build() {
                return new IosParameters(this.zzeac, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zzeac;

        private AndroidParameters(Bundle bundle) {
            this.zzeac = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzeac;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zzeac = new Bundle();
                this.zzeac.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zzeac = new Bundle();
                this.zzeac.putString("apn", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzeac.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            public final Builder setMinimumVersion(int n) {
                this.zzeac.putInt("amv", n);
                return this;
            }

            public final AndroidParameters build() {
                return new AndroidParameters(this.zzeac, null);
            }
        }
    }

    public static final class Builder {
        private final zzemd zznft;
        private final Bundle zznfs;
        private final Bundle zznfu;

        public Builder(zzemd zzemd2) {
            this.zznft = zzemd2;
            this.zznfs = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zznfs.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zznfu = new Bundle();
            this.zznfs.putBundle("parameters", this.zznfu);
        }

        public final Builder setLongLink(@NonNull Uri uri) {
            this.zznfs.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        public final Builder setLink(@NonNull Uri uri) {
            this.zznfu.putParcelable("link", (Parcelable)uri);
            return this;
        }

        public final Builder setDynamicLinkDomain(@NonNull String string) {
            this.zznfs.putString("domain", string);
            return this;
        }

        public final Builder setAndroidParameters(AndroidParameters androidParameters) {
            this.zznfu.putAll(androidParameters.zzeac);
            return this;
        }

        public final Builder setIosParameters(IosParameters iosParameters) {
            this.zznfu.putAll(iosParameters.zzeac);
            return this;
        }

        public final Builder setGoogleAnalyticsParameters(GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zznfu.putAll(googleAnalyticsParameters.zzeac);
            return this;
        }

        public final Builder setItunesConnectAnalyticsParameters(ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zznfu.putAll(itunesConnectAnalyticsParameters.zzeac);
            return this;
        }

        public final Builder setSocialMetaTagParameters(SocialMetaTagParameters socialMetaTagParameters) {
            this.zznfu.putAll(socialMetaTagParameters.zzeac);
            return this;
        }

        public final Builder setNavigationInfoParameters(NavigationInfoParameters navigationInfoParameters) {
            this.zznfu.putAll(navigationInfoParameters.zzeac);
            return this;
        }

        public final DynamicLink buildDynamicLink() {
            zzemd.zzab(this.zznfs);
            return new DynamicLink(this.zznfs);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zzcbi();
            return this.zznft.zzaa(this.zznfs);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zzcbi();
            this.zznfs.putInt("suffix", n);
            return this.zznft.zzaa(this.zznfs);
        }

        private final void zzcbi() {
            if (this.zznfs.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

