/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.zzde;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.internal.zzepi;
import com.google.android.gms.internal.zzepk;
import com.google.android.gms.internal.zzepq;
import com.google.android.gms.internal.zzeps;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.dynamiclinks.DynamicLink;
import com.google.firebase.dynamiclinks.FirebaseDynamicLinks;
import com.google.firebase.dynamiclinks.PendingDynamicLinkData;
import com.google.firebase.dynamiclinks.ShortDynamicLink;

public final class zzepn
extends FirebaseDynamicLinks {
    private final GoogleApi<Api.ApiOptions.NoOptions> zza;

    public zzepn(@NonNull Context context) {
        this(new zzepk(context));
    }

    private zzepn(@NonNull GoogleApi<Api.ApiOptions.NoOptions> googleApi) {
        this.zza = googleApi;
    }

    private final void zza() {
        try {
            AppMeasurement.getInstance((Context)this.zza.zzg());
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Log.w((String)"FDL", (String)"FDL logging failed. Add a dependency for Firebase Analytics to your app to enable logging of Dynamic Link events.");
            return;
        }
    }

    @Override
    public final Task<PendingDynamicLinkData> getDynamicLink(@NonNull Intent intent) {
        this.zza();
        Task task = this.zza.zzb((zzde)new zzeps(this.zza.zzg(), intent.getDataString()));
        zzepi zzepi2 = (zzepi)zzbgq.zza((Intent)intent, (String)"com.google.firebase.dynamiclinks.DYNAMIC_LINK_DATA", zzepi.CREATOR);
        PendingDynamicLinkData pendingDynamicLinkData = zzepi2 != null ? new PendingDynamicLinkData(zzepi2) : null;
        if (pendingDynamicLinkData != null) {
            task = Tasks.forResult((Object)pendingDynamicLinkData);
        }
        return task;
    }

    @Override
    public final Task<PendingDynamicLinkData> getDynamicLink(@NonNull Uri uri) {
        this.zza();
        return this.zza.zzb((zzde)new zzeps(this.zza.zzg(), uri.toString()));
    }

    @Override
    public final DynamicLink.Builder createDynamicLink() {
        return new DynamicLink.Builder(this);
    }

    public final Task<ShortDynamicLink> zza(Bundle bundle) {
        zzepn.zzb(bundle);
        return this.zza.zzb((zzde)new zzepq(bundle));
    }

    public static void zzb(Bundle bundle) {
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (TextUtils.isEmpty((CharSequence)bundle.getString("domain")) && uri == null) {
            throw new IllegalArgumentException("FDL domain is missing. Set with setDynamicLinkDomain().");
        }
    }
}

