/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzepn;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zza;

    DynamicLink(Bundle bundle) {
        this.zza = bundle;
    }

    public final Uri getUri() {
        Bundle bundle = this.zza;
        zzepn.zzb(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            builder.scheme("https");
            builder.authority(bundle.getString("domain"));
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class NavigationInfoParameters {
        final Bundle zza;

        private NavigationInfoParameters(Bundle bundle) {
            this.zza = bundle;
        }

        /* synthetic */ NavigationInfoParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zza = new Bundle();

            public Builder() {
            }

            public final Builder setForcedRedirectEnabled(boolean bl) {
                this.zza.putInt("efr", bl ? 1 : 0);
                return this;
            }

            public final NavigationInfoParameters build() {
                return new NavigationInfoParameters(this.zza, null);
            }
        }
    }

    public static final class SocialMetaTagParameters {
        final Bundle zza;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zza = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zza = new Bundle();

            public Builder() {
            }

            public final Builder setTitle(String string) {
                this.zza.putString("st", string);
                return this;
            }

            public final Builder setDescription(String string) {
                this.zza.putString("sd", string);
                return this;
            }

            public final Builder setImageUrl(Uri uri) {
                this.zza.putParcelable("si", (Parcelable)uri);
                return this;
            }

            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zza, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zza;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zza = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zza = new Bundle();

            public Builder() {
            }

            public final Builder setProviderToken(String string) {
                this.zza.putString("pt", string);
                return this;
            }

            public final Builder setAffiliateToken(String string) {
                this.zza.putString("at", string);
                return this;
            }

            public final Builder setCampaignToken(String string) {
                this.zza.putString("ct", string);
                return this;
            }

            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zza, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zza;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zza = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zza = new Bundle();

            public Builder() {
            }

            public Builder(String string, String string2, String string3) {
                this.zza.putString("utm_source", string);
                this.zza.putString("utm_medium", string2);
                this.zza.putString("utm_campaign", string3);
            }

            public final Builder setSource(String string) {
                this.zza.putString("utm_source", string);
                return this;
            }

            public final Builder setMedium(String string) {
                this.zza.putString("utm_medium", string);
                return this;
            }

            public final Builder setCampaign(String string) {
                this.zza.putString("utm_campaign", string);
                return this;
            }

            public final Builder setTerm(String string) {
                this.zza.putString("utm_term", string);
                return this;
            }

            public final Builder setContent(String string) {
                this.zza.putString("utm_content", string);
                return this;
            }

            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zza, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zza;

        private IosParameters(Bundle bundle) {
            this.zza = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zza = new Bundle();

            public Builder(@NonNull String string) {
                this.zza.putString("ibi", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zza.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            public final Builder setCustomScheme(String string) {
                this.zza.putString("ius", string);
                return this;
            }

            public final Builder setIpadFallbackUrl(Uri uri) {
                this.zza.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            public final Builder setIpadBundleId(String string) {
                this.zza.putString("ipbi", string);
                return this;
            }

            public final Builder setAppStoreId(String string) {
                this.zza.putString("isi", string);
                return this;
            }

            public final Builder setMinimumVersion(String string) {
                this.zza.putString("imv", string);
                return this;
            }

            public final IosParameters build() {
                return new IosParameters(this.zza, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zza;

        private AndroidParameters(Bundle bundle) {
            this.zza = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zza;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zza = new Bundle();
                this.zza.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zza = new Bundle();
                this.zza.putString("apn", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zza.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            public final Builder setMinimumVersion(int n) {
                this.zza.putInt("amv", n);
                return this;
            }

            public final AndroidParameters build() {
                return new AndroidParameters(this.zza, null);
            }
        }
    }

    public static final class Builder {
        private final zzepn zza;
        private final Bundle zzb;
        private final Bundle zzc;

        @Hide
        public Builder(zzepn zzepn2) {
            this.zza = zzepn2;
            this.zzb = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zzb.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zzc = new Bundle();
            this.zzb.putBundle("parameters", this.zzc);
        }

        public final Builder setLongLink(@NonNull Uri uri) {
            this.zzb.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        public final Builder setLink(@NonNull Uri uri) {
            this.zzc.putParcelable("link", (Parcelable)uri);
            return this;
        }

        public final Builder setDynamicLinkDomain(@NonNull String string) {
            this.zzb.putString("domain", string);
            return this;
        }

        public final Builder setAndroidParameters(AndroidParameters androidParameters) {
            this.zzc.putAll(androidParameters.zza);
            return this;
        }

        public final Builder setIosParameters(IosParameters iosParameters) {
            this.zzc.putAll(iosParameters.zza);
            return this;
        }

        public final Builder setGoogleAnalyticsParameters(GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zzc.putAll(googleAnalyticsParameters.zza);
            return this;
        }

        public final Builder setItunesConnectAnalyticsParameters(ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zzc.putAll(itunesConnectAnalyticsParameters.zza);
            return this;
        }

        public final Builder setSocialMetaTagParameters(SocialMetaTagParameters socialMetaTagParameters) {
            this.zzc.putAll(socialMetaTagParameters.zza);
            return this;
        }

        public final Builder setNavigationInfoParameters(NavigationInfoParameters navigationInfoParameters) {
            this.zzc.putAll(navigationInfoParameters.zza);
            return this;
        }

        public final DynamicLink buildDynamicLink() {
            zzepn.zzb(this.zzb);
            return new DynamicLink(this.zzb);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zza();
            return this.zza.zza(this.zzb);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zza();
            this.zzb.putInt("suffix", n);
            return this.zza.zza(this.zzb);
        }

        private final void zza() {
            if (this.zzb.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

