/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks.internal;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.TaskUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.dynamiclinks.DynamicLink;
import com.google.firebase.dynamiclinks.FirebaseDynamicLinks;
import com.google.firebase.dynamiclinks.PendingDynamicLinkData;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.internal.DynamicLinkData;
import com.google.firebase.dynamiclinks.internal.DynamicLinksApi;
import com.google.firebase.dynamiclinks.internal.DynamicLinksClient;
import com.google.firebase.dynamiclinks.internal.IDynamicLinksCallbacks;
import com.google.firebase.dynamiclinks.internal.ShortDynamicLinkImpl;
import com.google.firebase.inject.Provider;

public class FirebaseDynamicLinksImpl
extends FirebaseDynamicLinks {
    public static final String KEY_SCION_DATA = "scionData";
    public static final String EXTRA_DYNAMIC_LINK_DATA = "com.google.firebase.dynamiclinks.DYNAMIC_LINK_DATA";
    private static final String TAG = "FDL";
    private static final String ANALYTICS_FDL_ORIGIN = "fdl";
    private final GoogleApi<Api.ApiOptions.NoOptions> googleApi;
    private final Provider<AnalyticsConnector> analytics;
    private final FirebaseApp firebaseApp;

    public FirebaseDynamicLinksImpl(FirebaseApp firebaseApp, Provider<AnalyticsConnector> analytics) {
        this(new DynamicLinksApi(firebaseApp.getApplicationContext()), firebaseApp, analytics);
    }

    @VisibleForTesting
    public FirebaseDynamicLinksImpl(GoogleApi<Api.ApiOptions.NoOptions> googleApi, FirebaseApp firebaseApp, Provider<AnalyticsConnector> analytics) {
        this.googleApi = googleApi;
        this.firebaseApp = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.analytics = analytics;
        if (analytics.get() == null) {
            Log.w((String)TAG, (String)"FDL logging failed. Add a dependency for Firebase Analytics to your app to enable logging of Dynamic Link events.");
        }
    }

    public FirebaseApp getFirebaseApp() {
        return this.firebaseApp;
    }

    @Nullable
    public PendingDynamicLinkData getPendingDynamicLinkData(@NonNull Intent intent) {
        DynamicLinkData dynamicLinkData = (DynamicLinkData)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)EXTRA_DYNAMIC_LINK_DATA, DynamicLinkData.CREATOR);
        return dynamicLinkData != null ? new PendingDynamicLinkData(dynamicLinkData) : null;
    }

    @Override
    public Task<PendingDynamicLinkData> getDynamicLink(@Nullable Intent intent) {
        PendingDynamicLinkData pendingDynamicLinkData;
        String dynamicLinkDataString = intent != null ? intent.getDataString() : null;
        Task result = this.googleApi.doWrite((TaskApiCall)new GetDynamicLinkImpl(this.analytics, dynamicLinkDataString));
        if (intent != null && (pendingDynamicLinkData = this.getPendingDynamicLinkData(intent)) != null) {
            result = Tasks.forResult((Object)pendingDynamicLinkData);
        }
        return result;
    }

    @Override
    public Task<PendingDynamicLinkData> getDynamicLink(@NonNull Uri dynamicLinkUri) {
        return this.googleApi.doWrite((TaskApiCall)new GetDynamicLinkImpl(this.analytics, dynamicLinkUri.toString()));
    }

    @Override
    public DynamicLink.Builder createDynamicLink() {
        return new DynamicLink.Builder(this);
    }

    public static Uri createDynamicLink(Bundle builderParameters) {
        FirebaseDynamicLinksImpl.verifyDomainUriPrefix(builderParameters);
        Uri longLink = (Uri)builderParameters.getParcelable("dynamicLink");
        if (longLink == null) {
            Uri.Builder builder = new Uri.Builder();
            String domainUriPrefix = (String)Preconditions.checkNotNull((Object)builderParameters.getString("domainUriPrefix"));
            Uri uri = Uri.parse((String)domainUriPrefix);
            builder.scheme(uri.getScheme());
            builder.authority(uri.getAuthority());
            builder.path(uri.getPath());
            Bundle fdlParameters = builderParameters.getBundle("parameters");
            if (fdlParameters != null) {
                for (String key : fdlParameters.keySet()) {
                    Object value = fdlParameters.get(key);
                    if (value == null) continue;
                    builder.appendQueryParameter(key, value.toString());
                }
            }
            longLink = builder.build();
        }
        return longLink;
    }

    public Task<ShortDynamicLink> createShortDynamicLink(Bundle builderParameters) {
        FirebaseDynamicLinksImpl.verifyDomainUriPrefix(builderParameters);
        return this.googleApi.doWrite((TaskApiCall)new CreateShortDynamicLinkImpl(builderParameters));
    }

    public static void verifyDomainUriPrefix(Bundle builderParameters) {
        Uri longLink = (Uri)builderParameters.getParcelable("dynamicLink");
        if (TextUtils.isEmpty((CharSequence)builderParameters.getString("domainUriPrefix")) && longLink == null) {
            throw new IllegalArgumentException("FDL domain is missing. Set with setDomainUriPrefix() or setDynamicLinkDomain().");
        }
    }

    static class CreateShortDynamicLinkCallbacks
    extends AbstractDynamicLinkCallbacks {
        private final TaskCompletionSource<ShortDynamicLink> completionSource;

        CreateShortDynamicLinkCallbacks(TaskCompletionSource<ShortDynamicLink> completionSource) {
            this.completionSource = completionSource;
        }

        @Override
        public void onCreateShortDynamicLink(Status status, @Nullable ShortDynamicLinkImpl shortDynamicLink) {
            TaskUtil.setResultOrApiException((Status)status, (Object)shortDynamicLink, this.completionSource);
        }
    }

    static class DynamicLinkCallbacks
    extends AbstractDynamicLinkCallbacks {
        private final TaskCompletionSource<PendingDynamicLinkData> completionSource;
        private final Provider<AnalyticsConnector> analytics;

        public DynamicLinkCallbacks(Provider<AnalyticsConnector> analytics, TaskCompletionSource<PendingDynamicLinkData> completionSource) {
            this.analytics = analytics;
            this.completionSource = completionSource;
        }

        @Override
        public void onGetDynamicLink(Status status, @Nullable DynamicLinkData dynamicLinkData) {
            TaskUtil.setResultOrApiException((Status)status, (Object)(dynamicLinkData == null ? null : new PendingDynamicLinkData(dynamicLinkData)), this.completionSource);
            if (dynamicLinkData == null) {
                return;
            }
            Bundle scionData = dynamicLinkData.getExtensionBundle().getBundle(FirebaseDynamicLinksImpl.KEY_SCION_DATA);
            if (scionData == null || scionData.keySet() == null) {
                return;
            }
            AnalyticsConnector connector = (AnalyticsConnector)this.analytics.get();
            if (connector == null) {
                return;
            }
            for (String name : scionData.keySet()) {
                Bundle params = scionData.getBundle(name);
                connector.logEvent(FirebaseDynamicLinksImpl.ANALYTICS_FDL_ORIGIN, name, params);
            }
        }
    }

    static class AbstractDynamicLinkCallbacks
    extends IDynamicLinksCallbacks.Stub {
        AbstractDynamicLinkCallbacks() {
        }

        @Override
        public void onGetDynamicLink(Status status, @Nullable DynamicLinkData dynamicLinkData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onCreateShortDynamicLink(Status status, @Nullable ShortDynamicLinkImpl shortDynamicLink) {
            throw new UnsupportedOperationException();
        }
    }

    static final class CreateShortDynamicLinkImpl
    extends TaskApiCall<DynamicLinksClient, ShortDynamicLink> {
        private final Bundle builderParameters;

        CreateShortDynamicLinkImpl(Bundle builderParameters) {
            super(null, false, 13202);
            this.builderParameters = builderParameters;
        }

        protected void doExecute(DynamicLinksClient clientImpl, TaskCompletionSource<ShortDynamicLink> completionSource) throws RemoteException {
            clientImpl.createShortDynamicLink(new CreateShortDynamicLinkCallbacks(completionSource), this.builderParameters);
        }
    }

    static final class GetDynamicLinkImpl
    extends TaskApiCall<DynamicLinksClient, PendingDynamicLinkData> {
        @Nullable
        private final String dynamicLink;
        private final Provider<AnalyticsConnector> analytics;

        GetDynamicLinkImpl(Provider<AnalyticsConnector> analytics, @Nullable String dynamicLink) {
            super(null, false, 13201);
            this.dynamicLink = dynamicLink;
            this.analytics = analytics;
        }

        protected void doExecute(DynamicLinksClient clientImpl, TaskCompletionSource<PendingDynamicLinkData> completionSource) throws RemoteException {
            clientImpl.getDynamicLink(new DynamicLinkCallbacks(this.analytics, completionSource), this.dynamicLink);
        }
    }
}

