/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.dynamiclinks.internal.DynamicLinkData;
import com.google.firebase.dynamiclinks.internal.DynamicLinkUTMParams;

public class PendingDynamicLinkData {
    @Nullable
    private final DynamicLinkUTMParams dynamicLinkUTMParams;
    @Nullable
    private final DynamicLinkData dynamicLinkData;

    @KeepForSdk
    @VisibleForTesting
    public PendingDynamicLinkData(DynamicLinkData dynamicLinkData) {
        if (dynamicLinkData == null) {
            this.dynamicLinkData = null;
            this.dynamicLinkUTMParams = null;
            return;
        }
        if (dynamicLinkData.getClickTimestamp() == 0L) {
            long now = DefaultClock.getInstance().currentTimeMillis();
            dynamicLinkData.setClickTimestamp(now);
        }
        this.dynamicLinkData = dynamicLinkData;
        this.dynamicLinkUTMParams = new DynamicLinkUTMParams(dynamicLinkData);
    }

    protected PendingDynamicLinkData(@Nullable String deepLink, int minVersion, long clickTimestamp, @Nullable Uri redirectUrl) {
        this.dynamicLinkData = new DynamicLinkData(null, deepLink, minVersion, clickTimestamp, null, redirectUrl);
        this.dynamicLinkUTMParams = new DynamicLinkUTMParams(this.dynamicLinkData);
    }

    @KeepForSdk
    @Nullable
    public Bundle getExtensions() {
        if (this.dynamicLinkData == null) {
            return new Bundle();
        }
        return this.dynamicLinkData.getExtensionBundle();
    }

    @Nullable
    public Uri getLink() {
        if (this.dynamicLinkData == null) {
            return null;
        }
        String deepLink = this.dynamicLinkData.getDeepLink();
        if (deepLink != null) {
            return Uri.parse((String)deepLink);
        }
        return null;
    }

    @NonNull
    public Bundle getUtmParameters() {
        if (this.dynamicLinkUTMParams == null) {
            return new Bundle();
        }
        return this.dynamicLinkUTMParams.asBundle();
    }

    public int getMinimumAppVersion() {
        if (this.dynamicLinkData == null) {
            return 0;
        }
        return this.dynamicLinkData.getMinVersion();
    }

    public long getClickTimestamp() {
        if (this.dynamicLinkData == null) {
            return 0L;
        }
        return this.dynamicLinkData.getClickTimestamp();
    }

    @VisibleForTesting
    @Nullable
    public Uri getRedirectUrl() {
        if (this.dynamicLinkData == null) {
            return null;
        }
        return this.dynamicLinkData.getRedirectUrl();
    }

    @Nullable
    public Intent getUpdateAppIntent(@NonNull Context context) {
        int versionCode;
        if (this.getMinimumAppVersion() == 0) {
            return null;
        }
        try {
            versionCode = context.getPackageManager().getPackageInfo((String)context.getApplicationContext().getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        if (versionCode < this.getMinimumAppVersion() && this.getRedirectUrl() != null) {
            return new Intent("android.intent.action.VIEW").setData(this.getRedirectUrl()).setPackage("com.android.vending");
        }
        return null;
    }
}

