/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks.internal;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.dynamiclinks.internal.DynamicLinkData;

public class DynamicLinkUTMParams {
    @VisibleForTesting
    public static final String KEY_CAMPAIGN_BUNDLE = "_cmp";
    @VisibleForTesting
    public static final String KEY_SCION_DATA_BUNDLE = "scionData";
    @VisibleForTesting
    public static final String KEY_MEDIUM = "medium";
    @VisibleForTesting
    public static final String KEY_SOURCE = "source";
    @VisibleForTesting
    public static final String KEY_CAMPAIGN = "campaign";
    public static final String KEY_UTM_MEDIUM = "utm_medium";
    public static final String KEY_UTM_SOURCE = "utm_source";
    public static final String KEY_UTM_CAMPAIGN = "utm_campaign";
    private final DynamicLinkData dynamicLinkData;
    @NonNull
    private final Bundle utmParamsBundle;

    public DynamicLinkUTMParams(DynamicLinkData dynamicLinkData) {
        this.dynamicLinkData = dynamicLinkData;
        this.utmParamsBundle = DynamicLinkUTMParams.initUTMParamsBundle(dynamicLinkData);
    }

    @NonNull
    public Bundle asBundle() {
        return new Bundle(this.utmParamsBundle);
    }

    @NonNull
    private static Bundle initUTMParamsBundle(DynamicLinkData dynamicLinkData) {
        Bundle bundle = new Bundle();
        if (dynamicLinkData == null || dynamicLinkData.getExtensionBundle() == null) {
            return bundle;
        }
        Bundle scionBundle = dynamicLinkData.getExtensionBundle().getBundle(KEY_SCION_DATA_BUNDLE);
        if (scionBundle == null) {
            return bundle;
        }
        Bundle campaignBundle = scionBundle.getBundle(KEY_CAMPAIGN_BUNDLE);
        if (campaignBundle == null) {
            return bundle;
        }
        DynamicLinkUTMParams.checkAndAdd(KEY_MEDIUM, KEY_UTM_MEDIUM, campaignBundle, bundle);
        DynamicLinkUTMParams.checkAndAdd(KEY_SOURCE, KEY_UTM_SOURCE, campaignBundle, bundle);
        DynamicLinkUTMParams.checkAndAdd(KEY_CAMPAIGN, KEY_UTM_CAMPAIGN, campaignBundle, bundle);
        return bundle;
    }

    private static void checkAndAdd(@NonNull String sourceKey, @NonNull String destKey, @NonNull Bundle source, @NonNull Bundle dest) {
        String value = source.getString(sourceKey);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            dest.putString(destKey, value);
        }
    }
}

