/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.common.api.Status;
import com.google.firebase.dynamiclinks.internal.DynamicLinkData;
import com.google.firebase.dynamiclinks.internal.ShortDynamicLinkImpl;

public interface IDynamicLinksCallbacks
extends IInterface {
    public void onGetDynamicLink(Status var1, DynamicLinkData var2) throws RemoteException;

    public void onCreateShortDynamicLink(Status var1, ShortDynamicLinkImpl var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDynamicLinksCallbacks {
        private static final String DESCRIPTOR = "com.google.firebase.dynamiclinks.internal.IDynamicLinksCallbacks";
        static final int TRANSACTION_onGetDynamicLink = 1;
        static final int TRANSACTION_onCreateShortDynamicLink = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDynamicLinksCallbacks asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDynamicLinksCallbacks) {
                return (IDynamicLinksCallbacks)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    Status _arg0 = 0 != data.readInt() ? (Status)Status.CREATOR.createFromParcel(data) : null;
                    DynamicLinkData _arg1 = 0 != data.readInt() ? (DynamicLinkData)((Object)DynamicLinkData.CREATOR.createFromParcel(data)) : null;
                    this.onGetDynamicLink(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    Status _arg0 = 0 != data.readInt() ? (Status)Status.CREATOR.createFromParcel(data) : null;
                    ShortDynamicLinkImpl _arg1 = 0 != data.readInt() ? (ShortDynamicLinkImpl)ShortDynamicLinkImpl.CREATOR.createFromParcel(data) : null;
                    this.onCreateShortDynamicLink(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IDynamicLinksCallbacks impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IDynamicLinksCallbacks getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IDynamicLinksCallbacks {
            private IBinder mRemote;
            public static IDynamicLinksCallbacks sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGetDynamicLink(Status status, DynamicLinkData dynamicLinksData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (status != null) {
                        _data.writeInt(1);
                        status.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (dynamicLinksData != null) {
                        _data.writeInt(1);
                        dynamicLinksData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onGetDynamicLink(status, dynamicLinksData);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreateShortDynamicLink(Status status, ShortDynamicLinkImpl shortDynamicLink) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (status != null) {
                        _data.writeInt(1);
                        status.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (shortDynamicLink != null) {
                        _data.writeInt(1);
                        shortDynamicLink.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCreateShortDynamicLink(status, shortDynamicLink);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDynamicLinksCallbacks {
        @Override
        public void onGetDynamicLink(Status status, DynamicLinkData dynamicLinksData) throws RemoteException {
        }

        @Override
        public void onCreateShortDynamicLink(Status status, ShortDynamicLinkImpl shortDynamicLink) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

