/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.common.base.Preconditions;
import java.util.Date;

public final class Timestamp
implements Parcelable,
Comparable<Timestamp> {
    public static final Parcelable.Creator<Timestamp> CREATOR = new Parcelable.Creator<Timestamp>(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new Timestamp(parcel);
        }
    };
    private final long zza;
    private final int zzb;

    /*
     * WARNING - void declaration
     */
    public Timestamp(long seconds, int nanoseconds) {
        void var3_2;
        void var1_1;
        Timestamp.zza(seconds, nanoseconds);
        this.zza = var1_1;
        this.zzb = var3_2;
    }

    /*
     * WARNING - void declaration
     */
    protected Timestamp(Parcel in) {
        void var1_1;
        this.zza = in.readLong();
        this.zzb = var1_1.readInt();
    }

    /*
     * WARNING - void declaration
     */
    public Timestamp(Date date) {
        void var1_1;
        long l = var1_1.getTime();
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        if (n < 0) {
            --l2;
            n += 1000000000;
        }
        Timestamp.zza(l2, n);
        this.zza = l2;
        this.zzb = n;
    }

    public static Timestamp now() {
        return new Timestamp(new Date());
    }

    public final long getSeconds() {
        return this.zza;
    }

    public final int getNanoseconds() {
        return this.zzb;
    }

    public final Date toDate() {
        return new Date(this.zza * 1000L + (long)(this.zzb / 1000000));
    }

    public final int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeToParcel(Parcel dest, int flags) {
        void var1_1;
        dest.writeLong(this.zza);
        var1_1.writeInt(this.zzb);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Timestamp other) {
        void var1_1;
        if (this.zza == other.zza) {
            return Integer.signum(this.zzb - other.zzb);
        }
        return Long.signum(this.zza - var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        if (!(other instanceof Timestamp)) {
            return false;
        }
        return this.compareTo((Timestamp)var1_1) == 0;
    }

    public final int hashCode() {
        int n = 37 * (int)this.zza;
        n = n * 37 + (int)(this.zza >> 32);
        n = n * 37 + this.zzb;
        return n;
    }

    public final String toString() {
        return "Timestamp(seconds=" + this.zza + ", nanoseconds=" + this.zzb + ")";
    }

    private static void zza(long l, int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (String)"Timestamp nanoseconds out of range: %d", (int)n);
        Preconditions.checkArgument(((double)n < 1.0E9 ? 1 : 0) != 0, (String)"Timestamp nanoseconds out of range: %d", (int)n);
        Preconditions.checkArgument((l >= -62135596800L ? 1 : 0) != 0, (String)"Timestamp seconds out of range: %d", (long)l);
        Preconditions.checkArgument((l < 253402300800L ? 1 : 0) != 0, (String)"Timestamp seconds out of range: %d", (long)l);
    }
}

