/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.b.zzx;
import com.google.firebase.firestore.d.zze;
import com.google.firebase.firestore.d.zzl;
import com.google.firebase.firestore.g.zzj;
import com.google.firebase.firestore.g.zzs;
import com.google.firebase.firestore.zza;
import java.util.Map;
import javax.annotation.Nullable;

public class CollectionReference
extends Query {
    /*
     * WARNING - void declaration
     */
    CollectionReference(zzl path, FirebaseFirestore firestore) {
        super(zzx.zza(path), (FirebaseFirestore)var2_2);
        void var2_2;
        if (path.zzg() % 2 != 1) {
            void var1_1;
            throw new IllegalArgumentException("Invalid collection reference. Collection references must have an odd number of segments, but " + path.zzf() + " has " + var1_1.zzg());
        }
    }

    @NonNull
    public String getId() {
        return this.zza.zza().zzc();
    }

    @Nullable
    public DocumentReference getParent() {
        zzl zzl2 = (zzl)this.zza.zza().zzb();
        if (zzl2.zze()) {
            return null;
        }
        return new DocumentReference(zze.zza(zzl2), this.zzb);
    }

    @NonNull
    public String getPath() {
        return this.zza.zza().zzf();
    }

    @NonNull
    public DocumentReference document() {
        return this.document(zzs.zza());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public DocumentReference document(@NonNull String documentPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)documentPath, (Object)"Provided document path must not be null.");
        return DocumentReference.forPath(this.zza.zza().zza(zzl.zzb((String)var1_1)), this.zzb);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<DocumentReference> add(@NonNull Map<String, Object> data) {
        void var1_1;
        Preconditions.checkNotNull(data, (Object)"Provided data must not be null.");
        DocumentReference documentReference = this.document();
        return documentReference.set((Map<String, Object>)var1_1).continueWith(zzj.zzb, (Continuation)new zza(documentReference));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<DocumentReference> add(@NonNull Object pojo) {
        void var1_1;
        CollectionReference collectionReference = this;
        return collectionReference.add(collectionReference.zzb.zzc().convertPOJO(var1_1));
    }

    static final /* synthetic */ DocumentReference zza(DocumentReference documentReference, Task task) throws Exception {
        task.getResult();
        return documentReference;
    }
}

