/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArrayValue
extends FieldValue {
    private final List<FieldValue> internalValue;

    private ArrayValue(List<FieldValue> value) {
        this.internalValue = Collections.unmodifiableList(value);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ArrayValue && this.internalValue.equals(((ArrayValue)o).internalValue);
    }

    @Override
    public int hashCode() {
        return this.internalValue.hashCode();
    }

    @Override
    public int compareTo(FieldValue o) {
        if (o instanceof ArrayValue) {
            ArrayValue other = (ArrayValue)o;
            int minLength = Math.min(this.internalValue.size(), other.internalValue.size());
            for (int i = 0; i < minLength; ++i) {
                int cmp = this.internalValue.get(i).compareTo(((ArrayValue)o).internalValue.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return Util.compareIntegers(this.internalValue.size(), other.internalValue.size());
        }
        return this.defaultCompareTo(o);
    }

    @Override
    public int typeOrder() {
        return 8;
    }

    @Override
    public List<Object> value() {
        ArrayList<Object> res = new ArrayList<Object>(this.internalValue.size());
        for (FieldValue v : this.internalValue) {
            res.add(v.value());
        }
        return res;
    }

    public List<FieldValue> getInternalValue() {
        return this.internalValue;
    }

    public static ArrayValue fromList(List<FieldValue> list) {
        return new ArrayValue(list);
    }
}

