/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.core.TransactionRunner$$Lambda$1;
import com.google.firebase.firestore.core.TransactionRunner$$Lambda$2;
import com.google.firebase.firestore.core.TransactionRunner$$Lambda$3;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.RemoteStore;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.ExponentialBackoff;
import com.google.firebase.firestore.util.Function;

public class TransactionRunner<TResult> {
    private static final int RETRY_COUNT = 5;
    private AsyncQueue asyncQueue;
    private RemoteStore remoteStore;
    private Function<Transaction, Task<TResult>> updateFunction;
    private int retriesLeft;
    private ExponentialBackoff backoff;
    private TaskCompletionSource<TResult> taskSource = new TaskCompletionSource();

    public TransactionRunner(AsyncQueue asyncQueue, RemoteStore remoteStore, Function<Transaction, Task<TResult>> updateFunction) {
        this.asyncQueue = asyncQueue;
        this.remoteStore = remoteStore;
        this.updateFunction = updateFunction;
        this.retriesLeft = 5;
        this.backoff = new ExponentialBackoff(asyncQueue, AsyncQueue.TimerId.RETRY_TRANSACTION);
    }

    public Task<TResult> run() {
        this.runWithBackoff();
        return this.taskSource.getTask();
    }

    private void runWithBackoff() {
        this.backoff.backoffAndRun(TransactionRunner$$Lambda$1.lambdaFactory$(this));
    }

    private void handleTransactionError(Task task) {
        if (this.retriesLeft > 0 && TransactionRunner.isRetryableTransactionError(task.getException())) {
            --this.retriesLeft;
            this.runWithBackoff();
        } else {
            this.taskSource.setException(task.getException());
        }
    }

    private static boolean isRetryableTransactionError(Exception e) {
        if (e instanceof FirebaseFirestoreException) {
            FirebaseFirestoreException.Code code = ((FirebaseFirestoreException)((Object)e)).getCode();
            return code == FirebaseFirestoreException.Code.ABORTED || code == FirebaseFirestoreException.Code.FAILED_PRECONDITION || !Datastore.isPermanentError(((FirebaseFirestoreException)((Object)e)).getCode());
        }
        return false;
    }

    static /* synthetic */ void lambda$runWithBackoff$2(TransactionRunner this_) {
        Transaction transaction = this_.remoteStore.createTransaction();
        this_.updateFunction.apply(transaction).addOnCompleteListener(this_.asyncQueue.getExecutor(), TransactionRunner$$Lambda$2.lambdaFactory$(this_, transaction));
    }

    static /* synthetic */ void lambda$runWithBackoff$1(TransactionRunner this_, Transaction transaction, Task userTask) {
        if (!userTask.isSuccessful()) {
            this_.handleTransactionError(userTask);
        } else {
            transaction.commit().addOnCompleteListener(this_.asyncQueue.getExecutor(), TransactionRunner$$Lambda$3.lambdaFactory$(this_, userTask));
        }
    }

    static /* synthetic */ void lambda$runWithBackoff$0(TransactionRunner this_, Task userTask, Task commitTask) {
        if (commitTask.isSuccessful()) {
            this_.taskSource.setResult(userTask.getResult());
        } else {
            this_.handleTransactionError(commitTask);
        }
    }
}

