/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.database.Cursor;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.MemoryIndexManager;
import com.google.firebase.firestore.local.SQLiteIndexManager$$Lambda$1;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.List;

final class SQLiteIndexManager
implements IndexManager {
    private final MemoryIndexManager.MemoryCollectionParentIndex collectionParentsCache = new MemoryIndexManager.MemoryCollectionParentIndex();
    private final SQLitePersistence db;

    SQLiteIndexManager(SQLitePersistence persistence) {
        this.db = persistence;
    }

    @Override
    public void addToCollectionParentIndex(ResourcePath collectionPath) {
        Assert.hardAssert(collectionPath.length() % 2 == 1, "Expected a collection path.", new Object[0]);
        if (this.collectionParentsCache.add(collectionPath)) {
            String collectionId = collectionPath.getLastSegment();
            ResourcePath parentPath = (ResourcePath)collectionPath.popLast();
            this.db.execute("INSERT OR REPLACE INTO collection_parents (collection_id, parent) VALUES (?, ?)", collectionId, EncodedPath.encode(parentPath));
        }
    }

    @Override
    public List<ResourcePath> getCollectionParents(String collectionId) {
        ArrayList<ResourcePath> parentPaths = new ArrayList<ResourcePath>();
        this.db.query("SELECT parent FROM collection_parents WHERE collection_id = ?").binding(collectionId).forEach(SQLiteIndexManager$$Lambda$1.lambdaFactory$(parentPaths));
        return parentPaths;
    }

    static /* synthetic */ void lambda$getCollectionParents$0(ArrayList parentPaths, Cursor row) {
        parentPaths.add(EncodedPath.decodeResourcePath(row.getString(0)));
    }
}

