/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.model.Document$$Lambda$1;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firestore.v1.Value;
import java.util.Comparator;

public final class Document
extends MaybeDocument {
    private static final Comparator<Document> KEY_COMPARATOR = Document$$Lambda$1.lambdaFactory$();
    private final DocumentState documentState;
    private ObjectValue objectValue;

    public static Comparator<Document> keyComparator() {
        return KEY_COMPARATOR;
    }

    public Document(DocumentKey key, SnapshotVersion version, ObjectValue objectValue, DocumentState documentState) {
        super(key, version);
        this.documentState = documentState;
        this.objectValue = objectValue;
    }

    @NonNull
    public ObjectValue getData() {
        return this.objectValue;
    }

    @Nullable
    public Value getField(FieldPath path) {
        return this.objectValue.get(path);
    }

    public boolean hasLocalMutations() {
        return this.documentState.equals((Object)DocumentState.LOCAL_MUTATIONS);
    }

    public boolean hasCommittedMutations() {
        return this.documentState.equals((Object)DocumentState.COMMITTED_MUTATIONS);
    }

    @Override
    public boolean hasPendingWrites() {
        return this.hasLocalMutations() || this.hasCommittedMutations();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        return this.getVersion().equals(document.getVersion()) && this.getKey().equals(document.getKey()) && this.documentState.equals((Object)document.documentState) && this.objectValue.equals(document.objectValue);
    }

    public int hashCode() {
        int result = this.getKey().hashCode();
        result = 31 * result + this.getVersion().hashCode();
        result = 31 * result + this.documentState.hashCode();
        result = 31 * result + this.objectValue.hashCode();
        return result;
    }

    public String toString() {
        return "Document{key=" + this.getKey() + ", data=" + this.getData() + ", version=" + this.getVersion() + ", documentState=" + this.documentState.name() + '}';
    }

    static /* synthetic */ int lambda$static$0(Document left, Document right) {
        return left.getKey().compareTo(right.getKey());
    }

    public static enum DocumentState {
        LOCAL_MUTATIONS,
        COMMITTED_MUTATIONS,
        SYNCED;

    }
}

