/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.UnknownDocument;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;

public final class PatchMutation
extends Mutation {
    private final ObjectValue value;
    private final FieldMask mask;

    public PatchMutation(DocumentKey key, ObjectValue value, FieldMask mask, Precondition precondition) {
        super(key, precondition);
        this.value = value;
        this.mask = mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchMutation that = (PatchMutation)o;
        return this.hasSameKeyAndPrecondition(that) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.keyAndPreconditionHashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "PatchMutation{" + this.keyAndPreconditionToString() + ", mask=" + this.mask + ", value=" + this.value + "}";
    }

    public ObjectValue getValue() {
        return this.value;
    }

    public FieldMask getMask() {
        return this.mask;
    }

    @Override
    public MaybeDocument applyToRemoteDocument(@Nullable MaybeDocument maybeDoc, MutationResult mutationResult) {
        this.verifyKeyMatches(maybeDoc);
        Assert.hardAssert(mutationResult.getTransformResults() == null, "Transform results received by PatchMutation.", new Object[0]);
        if (!this.getPrecondition().isValidFor(maybeDoc)) {
            return new UnknownDocument(this.getKey(), mutationResult.getVersion());
        }
        SnapshotVersion version = mutationResult.getVersion();
        ObjectValue newData = this.patchDocument(maybeDoc);
        return new Document(this.getKey(), version, newData, Document.DocumentState.COMMITTED_MUTATIONS);
    }

    @Override
    @Nullable
    public MaybeDocument applyToLocalView(@Nullable MaybeDocument maybeDoc, @Nullable MaybeDocument baseDoc, Timestamp localWriteTime) {
        this.verifyKeyMatches(maybeDoc);
        if (!this.getPrecondition().isValidFor(maybeDoc)) {
            return maybeDoc;
        }
        SnapshotVersion version = PatchMutation.getPostMutationVersion(maybeDoc);
        ObjectValue newData = this.patchDocument(maybeDoc);
        return new Document(this.getKey(), version, newData, Document.DocumentState.LOCAL_MUTATIONS);
    }

    @Override
    @Nullable
    public ObjectValue extractBaseValue(@Nullable MaybeDocument maybeDoc) {
        return null;
    }

    private ObjectValue patchDocument(@Nullable MaybeDocument maybeDoc) {
        ObjectValue data = maybeDoc instanceof Document ? ((Document)maybeDoc).getData() : ObjectValue.emptyObject();
        return this.patchObject(data);
    }

    private ObjectValue patchObject(ObjectValue obj) {
        ObjectValue.Builder builder = obj.toBuilder();
        for (FieldPath path : this.mask.getMask()) {
            if (path.isEmpty()) continue;
            Value newValue = this.value.get(path);
            if (newValue == null) {
                builder.delete(path);
                continue;
            }
            builder.set(path, newValue);
        }
        return builder.build();
    }
}

