/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.remote.FirestoreChannel;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$1;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$2;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$3;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$4;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$5;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$6;
import com.google.firebase.firestore.remote.GrpcCallProvider$$Lambda$7;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Supplier;
import com.google.firestore.v1.FirestoreGrpc;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.android.AndroidChannelBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GrpcCallProvider {
    private static final String LOG_TAG = "GrpcCallProvider";
    private static Supplier<ManagedChannelBuilder<?>> overrideChannelBuilderSupplier;
    private Task<ManagedChannel> channelTask;
    private final AsyncQueue asyncQueue;
    private CallOptions callOptions;
    private static final int CONNECTIVITY_ATTEMPT_TIMEOUT_MS = 15000;
    private AsyncQueue.DelayedTask connectivityAttemptTimer;
    private final Context context;
    private final DatabaseInfo databaseInfo;
    private final CallCredentials firestoreHeaders;

    @VisibleForTesting
    public static void overrideChannelBuilder(Supplier<ManagedChannelBuilder<?>> channelBuilderSupplier) {
        overrideChannelBuilderSupplier = channelBuilderSupplier;
    }

    GrpcCallProvider(AsyncQueue asyncQueue, Context context, DatabaseInfo databaseInfo, CallCredentials firestoreHeaders) {
        this.asyncQueue = asyncQueue;
        this.context = context;
        this.databaseInfo = databaseInfo;
        this.firestoreHeaders = firestoreHeaders;
        this.initChannelTask();
    }

    private ManagedChannel initChannel(Context context, DatabaseInfo databaseInfo) {
        ManagedChannelBuilder channelBuilder;
        try {
            ProviderInstaller.installIfNeeded((Context)context);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IllegalStateException e) {
            Logger.warn(LOG_TAG, "Failed to update ssl context: %s", e);
        }
        if (overrideChannelBuilderSupplier != null) {
            channelBuilder = overrideChannelBuilderSupplier.get();
        } else {
            channelBuilder = ManagedChannelBuilder.forTarget((String)databaseInfo.getHost());
            if (!databaseInfo.isSslEnabled()) {
                channelBuilder.usePlaintext();
            }
        }
        channelBuilder.keepAliveTime(30L, TimeUnit.SECONDS);
        AndroidChannelBuilder androidChannelBuilder = AndroidChannelBuilder.usingBuilder((ManagedChannelBuilder)channelBuilder).context(context);
        return androidChannelBuilder.build();
    }

    <ReqT, RespT> Task<ClientCall<ReqT, RespT>> createClientCall(MethodDescriptor<ReqT, RespT> methodDescriptor) {
        return this.channelTask.continueWithTask(this.asyncQueue.getExecutor(), GrpcCallProvider$$Lambda$1.lambdaFactory$(this, methodDescriptor));
    }

    void shutdown() {
        ManagedChannel channel = null;
        try {
            channel = (ManagedChannel)Tasks.await(this.channelTask);
        }
        catch (ExecutionException e) {
            Logger.warn(FirestoreChannel.class.getSimpleName(), "Channel is not initialized, shutdown will just do nothing. Channel initializing run into exception: %s", e);
            return;
        }
        catch (InterruptedException e) {
            Logger.warn(FirestoreChannel.class.getSimpleName(), "Interrupted while retrieving the gRPC Managed Channel", new Object[0]);
            Thread.currentThread().interrupt();
            return;
        }
        channel.shutdown();
        try {
            if (!channel.awaitTermination(1L, TimeUnit.SECONDS)) {
                Logger.debug(FirestoreChannel.class.getSimpleName(), "Unable to gracefully shutdown the gRPC ManagedChannel. Will attempt an immediate shutdown.", new Object[0]);
                channel.shutdownNow();
                if (!channel.awaitTermination(60L, TimeUnit.SECONDS)) {
                    Logger.warn(FirestoreChannel.class.getSimpleName(), "Unable to forcefully shutdown the gRPC ManagedChannel.", new Object[0]);
                }
            }
        }
        catch (InterruptedException e) {
            channel.shutdownNow();
            Logger.warn(FirestoreChannel.class.getSimpleName(), "Interrupted while shutting down the gRPC Managed Channel", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    private void onConnectivityStateChange(ManagedChannel channel) {
        ConnectivityState newState = channel.getState(true);
        Logger.debug(LOG_TAG, "Current gRPC connectivity state: " + newState, new Object[0]);
        this.clearConnectivityAttemptTimer();
        if (newState == ConnectivityState.CONNECTING) {
            Logger.debug(LOG_TAG, "Setting the connectivityAttemptTimer", new Object[0]);
            this.connectivityAttemptTimer = this.asyncQueue.enqueueAfterDelay(AsyncQueue.TimerId.CONNECTIVITY_ATTEMPT_TIMER, 15000L, GrpcCallProvider$$Lambda$2.lambdaFactory$(this, channel));
        }
        channel.notifyWhenStateChanged(newState, GrpcCallProvider$$Lambda$3.lambdaFactory$(this, channel));
    }

    private void resetChannel(ManagedChannel channel) {
        this.asyncQueue.enqueueAndForget(GrpcCallProvider$$Lambda$4.lambdaFactory$(this, channel));
    }

    private void initChannelTask() {
        this.channelTask = Tasks.call((Executor)Executors.BACKGROUND_EXECUTOR, (Callable)GrpcCallProvider$$Lambda$5.lambdaFactory$(this));
    }

    private void clearConnectivityAttemptTimer() {
        if (this.connectivityAttemptTimer != null) {
            Logger.debug(LOG_TAG, "Clearing the connectivityAttemptTimer", new Object[0]);
            this.connectivityAttemptTimer.cancel();
            this.connectivityAttemptTimer = null;
        }
    }

    static /* synthetic */ ManagedChannel lambda$initChannelTask$6(GrpcCallProvider this_) throws Exception {
        ManagedChannel channel = this_.initChannel(this_.context, this_.databaseInfo);
        this_.asyncQueue.enqueueAndForget(GrpcCallProvider$$Lambda$6.lambdaFactory$(this_, channel));
        FirestoreGrpc.FirestoreStub firestoreStub = (FirestoreGrpc.FirestoreStub)((FirestoreGrpc.FirestoreStub)FirestoreGrpc.newStub((Channel)channel).withCallCredentials(this_.firestoreHeaders)).withExecutor(this_.asyncQueue.getExecutor());
        this_.callOptions = firestoreStub.getCallOptions();
        Logger.debug(LOG_TAG, "Channel successfully reset.", new Object[0]);
        return channel;
    }

    static /* synthetic */ void lambda$initChannelTask$5(GrpcCallProvider this_, ManagedChannel channel) {
        this_.onConnectivityStateChange(channel);
    }

    static /* synthetic */ void lambda$resetChannel$4(GrpcCallProvider this_, ManagedChannel channel) {
        channel.shutdownNow();
        this_.initChannelTask();
    }

    static /* synthetic */ void lambda$onConnectivityStateChange$3(GrpcCallProvider this_, ManagedChannel channel) {
        this_.asyncQueue.enqueueAndForget(GrpcCallProvider$$Lambda$7.lambdaFactory$(this_, channel));
    }

    static /* synthetic */ void lambda$onConnectivityStateChange$2(GrpcCallProvider this_, ManagedChannel channel) {
        this_.onConnectivityStateChange(channel);
    }

    static /* synthetic */ void lambda$onConnectivityStateChange$1(GrpcCallProvider this_, ManagedChannel channel) {
        Logger.debug(LOG_TAG, "connectivityAttemptTimer elapsed. Resetting the channel.", new Object[0]);
        this_.clearConnectivityAttemptTimer();
        this_.resetChannel(channel);
    }

    static /* synthetic */ Task lambda$createClientCall$0(GrpcCallProvider this_, MethodDescriptor methodDescriptor, Task task) throws Exception {
        return Tasks.forResult((Object)((ManagedChannel)task.getResult()).newCall(methodDescriptor, this_.callOptions));
    }
}

