/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.index;

public class OrderedCodeReader {
    private static final long[] LENGTH_TO_MASK = new long[]{0L, 128L, 49152L, 0xE00000L, 0xF0000000L, 0xF800000000L, 0xFC0000000000L, 0xFE000000000000L, -72057594037927936L, Long.MIN_VALUE, 0L};
    private final byte[] buffer;
    private int position;
    private final StringBuilder stringBuilder = new StringBuilder();

    public OrderedCodeReader(byte[] buffer) {
        this.buffer = buffer;
    }

    public String readUtf8Ascending() {
        this.stringBuilder.setLength(0);
        int numBytes = this.findSeparatorAscending();
        int i = 0;
        while (i < numBytes) {
            byte b = this.readAscendingByte();
            if (Utf8Bytes.isOneByte(b)) {
                Utf8Bytes.handleOneByte(b, this.stringBuilder);
                ++i;
                continue;
            }
            if (Utf8Bytes.isTwoBytes(b)) {
                Utf8Bytes.handleTwoBytes(b, this.readAscendingByte(), this.stringBuilder);
                i += 2;
                continue;
            }
            if (Utf8Bytes.isThreeBytes(b)) {
                Utf8Bytes.handleThreeBytes(b, this.readAscendingByte(), this.readAscendingByte(), this.stringBuilder);
                i += 3;
                continue;
            }
            Utf8Bytes.handleFourBytes(b, this.readAscendingByte(), this.readAscendingByte(), this.readAscendingByte(), this.stringBuilder);
            i += 4;
        }
        this.readSeparatorAscending();
        return this.stringBuilder.toString();
    }

    public long readUnsignedLongAscending() {
        byte len = this.buffer[this.position];
        if (len > 8) {
            throw OrderedCodeReader.invalidOrderedCode();
        }
        ++this.position;
        int end = this.position + len;
        long result = 0L;
        while (this.position < end) {
            result <<= 8;
            result |= (long)(this.buffer[this.position++] & 0xFF);
        }
        return result;
    }

    public int position() {
        return this.position;
    }

    public void seek(int pos) {
        this.position = pos;
    }

    public boolean hasRemainingBytes() {
        return this.position < this.buffer.length;
    }

    private int findSeparatorAscending() {
        int numBytes = 0;
        for (int i = this.position; i < this.buffer.length; ++i) {
            if (this.buffer[i] == 0 && this.buffer[i + 1] == 1) {
                return numBytes;
            }
            if (this.buffer[i] == 0) {
                ++i;
            } else if (this.buffer[i] == -1) {
                ++i;
            }
            ++numBytes;
        }
        throw new IllegalArgumentException("Invalid encoded byte array");
    }

    public void readSeparatorAscending() {
        if (this.buffer[this.position] == 0 && this.buffer[this.position + 1] == 1) {
            this.position += 2;
            return;
        }
        throw OrderedCodeReader.invalidOrderedCode();
    }

    private byte readAscendingByte() {
        byte b;
        if ((b = this.buffer[this.position++]) == 0) {
            if ((b = this.buffer[this.position++]) != -1) {
                throw OrderedCodeReader.invalidOrderedCode();
            }
            return 0;
        }
        if (b == -1) {
            if ((b = this.buffer[this.position++]) != 0) {
                throw OrderedCodeReader.invalidOrderedCode();
            }
            return -1;
        }
        return b;
    }

    private static IllegalArgumentException invalidOrderedCode() {
        return new IllegalArgumentException("invalid ordered code bytes");
    }

    private static class Utf8Bytes {
        private Utf8Bytes() {
        }

        private static boolean isOneByte(byte b) {
            return b >= 0;
        }

        private static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        private static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        private static void handleOneByte(byte byte1, StringBuilder builder) {
            builder.append((char)byte1);
        }

        private static void handleTwoBytes(byte byte1, byte byte2, StringBuilder builder) {
            char c = (char)((byte1 & 0x1F) << 6 | Utf8Bytes.trailingByteValue(byte2));
            if (c < '\u0080') {
                throw new IllegalArgumentException("invalid utf8");
            }
            builder.append(c);
        }

        public static boolean isSurrogate(char ch) {
            return ch >= '\ud800' && ch < '\ue000';
        }

        public static boolean isBmpCodePoint(int codePoint) {
            return codePoint >>> 16 == 0;
        }

        public static char highSurrogate(int codePoint) {
            return (char)((codePoint >>> 10) + 55232);
        }

        public static char lowSurrogate(int codePoint) {
            return (char)((codePoint & 0x3FF) + 56320);
        }

        private static void handleThreeBytes(byte byte1, byte byte2, byte byte3, StringBuilder builder) {
            char c = (char)((byte1 & 0xF) << 12 | Utf8Bytes.trailingByteValue(byte2) << 6 | Utf8Bytes.trailingByteValue(byte3));
            if (c < '\u0800' || Utf8Bytes.isSurrogate(c)) {
                throw new IllegalArgumentException("invalid utf8");
            }
            builder.append(c);
        }

        private static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, StringBuilder builder) {
            int codepoint = (byte1 & 7) << 18 | Utf8Bytes.trailingByteValue(byte2) << 12 | Utf8Bytes.trailingByteValue(byte3) << 6 | Utf8Bytes.trailingByteValue(byte4);
            if (Utf8Bytes.isBmpCodePoint(codepoint)) {
                throw new IllegalArgumentException("invalid utf8");
            }
            builder.append(Utf8Bytes.highSurrogate(codepoint));
            builder.append(Utf8Bytes.lowSurrogate(codepoint));
        }

        private static int trailingByteValue(byte b) {
            if (b > -65) {
                throw new IllegalArgumentException("invalid utf8");
            }
            return b & 0x3F;
        }
    }
}

