/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;

public class IndexRange {
    @Nullable
    private final Value start;
    @Nullable
    private final Value end;
    private final FieldPath fieldPath;

    private IndexRange(Builder builder) {
        this.fieldPath = builder.fieldPath;
        this.start = builder.start;
        this.end = builder.end;
    }

    public FieldPath getFieldPath() {
        return this.fieldPath;
    }

    @Nullable
    public Value getStart() {
        return this.start;
    }

    @Nullable
    public Value getEnd() {
        return this.end;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FieldPath fieldPath;
        private Value start;
        private Value end;

        public Builder setFieldPath(FieldPath fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public Builder setStart(Value start) {
            this.start = start;
            return this;
        }

        public Builder setEnd(Value end) {
            this.end = end;
            return this;
        }

        public IndexRange build() {
            Assert.hardAssert(this.fieldPath != null, "Field path must be specified", new Object[0]);
            return new IndexRange(this);
        }
    }
}

