/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.VisibleForTesting;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.model.mutation.PatchMutation;
import com.google.firebase.firestore.util.Assert;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class LocalDocumentsView {
    private final RemoteDocumentCache remoteDocumentCache;
    private final MutationQueue mutationQueue;
    private final IndexManager indexManager;

    LocalDocumentsView(RemoteDocumentCache remoteDocumentCache, MutationQueue mutationQueue, IndexManager indexManager) {
        this.remoteDocumentCache = remoteDocumentCache;
        this.mutationQueue = mutationQueue;
        this.indexManager = indexManager;
    }

    @VisibleForTesting
    RemoteDocumentCache getRemoteDocumentCache() {
        return this.remoteDocumentCache;
    }

    @VisibleForTesting
    MutationQueue getMutationQueue() {
        return this.mutationQueue;
    }

    @VisibleForTesting
    IndexManager getIndexManager() {
        return this.indexManager;
    }

    Document getDocument(DocumentKey key) {
        List<MutationBatch> batches = this.mutationQueue.getAllMutationBatchesAffectingDocumentKey(key);
        return this.getDocument(key, batches);
    }

    private Document getDocument(DocumentKey key, List<MutationBatch> inBatches) {
        MutableDocument document = this.remoteDocumentCache.get(key);
        for (MutationBatch batch : inBatches) {
            batch.applyToLocalView(document);
        }
        return document;
    }

    private void applyLocalMutationsToDocuments(Map<DocumentKey, MutableDocument> docs, List<MutationBatch> batches) {
        for (Map.Entry<DocumentKey, MutableDocument> base : docs.entrySet()) {
            for (MutationBatch batch : batches) {
                batch.applyToLocalView(base.getValue());
            }
        }
    }

    ImmutableSortedMap<DocumentKey, Document> getDocuments(Iterable<DocumentKey> keys) {
        Map<DocumentKey, MutableDocument> docs = this.remoteDocumentCache.getAll(keys);
        return this.getLocalViewOfDocuments(docs);
    }

    ImmutableSortedMap<DocumentKey, Document> getLocalViewOfDocuments(Map<DocumentKey, MutableDocument> docs) {
        ImmutableSortedMap results = DocumentCollections.emptyDocumentMap();
        List<MutationBatch> batches = this.mutationQueue.getAllMutationBatchesAffectingDocumentKeys(docs.keySet());
        this.applyLocalMutationsToDocuments(docs, batches);
        for (Map.Entry<DocumentKey, MutableDocument> entry : docs.entrySet()) {
            results = results.insert((Object)entry.getKey(), (Object)entry.getValue());
        }
        return results;
    }

    ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingQuery(Query query, SnapshotVersion sinceReadTime) {
        ResourcePath path = query.getPath();
        if (query.isDocumentQuery()) {
            return this.getDocumentsMatchingDocumentQuery(path);
        }
        if (query.isCollectionGroupQuery()) {
            return this.getDocumentsMatchingCollectionGroupQuery(query, sinceReadTime);
        }
        return this.getDocumentsMatchingCollectionQuery(query, sinceReadTime);
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingDocumentQuery(ResourcePath path) {
        ImmutableSortedMap result = DocumentCollections.emptyDocumentMap();
        Document doc = this.getDocument(DocumentKey.fromPath(path));
        if (doc.isFoundDocument()) {
            result = result.insert((Object)doc.getKey(), (Object)doc);
        }
        return result;
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingCollectionGroupQuery(Query query, SnapshotVersion sinceReadTime) {
        Assert.hardAssert(query.getPath().isEmpty(), "Currently we only support collection group queries at the root.", new Object[0]);
        String collectionId = query.getCollectionGroup();
        ImmutableSortedMap results = DocumentCollections.emptyDocumentMap();
        List<ResourcePath> parents = this.indexManager.getCollectionParents(collectionId);
        for (ResourcePath parent : parents) {
            Query collectionQuery = query.asCollectionQueryAtPath((ResourcePath)((Object)parent.append(collectionId)));
            ImmutableSortedMap<DocumentKey, Document> collectionResults = this.getDocumentsMatchingCollectionQuery(collectionQuery, sinceReadTime);
            for (Map.Entry docEntry : collectionResults) {
                results = results.insert((Object)((DocumentKey)docEntry.getKey()), (Object)((Document)docEntry.getValue()));
            }
        }
        return results;
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingCollectionQuery(Query query, SnapshotVersion sinceReadTime) {
        ImmutableSortedMap remoteDocuments = this.remoteDocumentCache.getAllDocumentsMatchingQuery(query, sinceReadTime);
        List<MutationBatch> matchingBatches = this.mutationQueue.getAllMutationBatchesAffectingQuery(query);
        remoteDocuments = this.addMissingBaseDocuments(matchingBatches, remoteDocuments);
        for (MutationBatch batch : matchingBatches) {
            for (Mutation mutation : batch.getMutations()) {
                if (!query.getPath().isImmediateParentOf(mutation.getKey().getPath())) continue;
                DocumentKey key = mutation.getKey();
                MutableDocument document = (MutableDocument)remoteDocuments.get((Object)key);
                if (document == null) {
                    document = MutableDocument.newInvalidDocument(key);
                    remoteDocuments = remoteDocuments.insert((Object)key, (Object)document);
                }
                mutation.applyToLocalView(document, FieldMask.fromSet(new HashSet<FieldPath>()), batch.getLocalWriteTime());
                if (document.isFoundDocument()) continue;
                remoteDocuments = remoteDocuments.remove((Object)key);
            }
        }
        ImmutableSortedMap results = DocumentCollections.emptyDocumentMap();
        for (Map.Entry docEntry : remoteDocuments) {
            if (!query.matches((Document)docEntry.getValue())) continue;
            results = results.insert((Object)((DocumentKey)docEntry.getKey()), (Object)((Document)docEntry.getValue()));
        }
        return results;
    }

    private ImmutableSortedMap<DocumentKey, MutableDocument> addMissingBaseDocuments(List<MutationBatch> matchingBatches, ImmutableSortedMap<DocumentKey, MutableDocument> existingDocs) {
        HashSet<DocumentKey> missingDocKeys = new HashSet<DocumentKey>();
        for (MutationBatch batch : matchingBatches) {
            for (Mutation mutation : batch.getMutations()) {
                if (!(mutation instanceof PatchMutation) || existingDocs.containsKey((Object)mutation.getKey())) continue;
                missingDocKeys.add(mutation.getKey());
            }
        }
        ImmutableSortedMap mergedDocs = existingDocs;
        Map<DocumentKey, MutableDocument> missingDocs = this.remoteDocumentCache.getAll(missingDocKeys);
        for (Map.Entry entry : missingDocs.entrySet()) {
            if (!((MutableDocument)entry.getValue()).isFoundDocument()) continue;
            mergedDocs = mergedDocs.insert((Object)((DocumentKey)entry.getKey()), (Object)((MutableDocument)entry.getValue()));
        }
        return mergedDocs;
    }
}

