/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.Pair;
import androidx.annotation.NonNull;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MemoryPersistence;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class MemoryRemoteDocumentCache
implements RemoteDocumentCache {
    private ImmutableSortedMap<DocumentKey, Pair<MutableDocument, SnapshotVersion>> docs = ImmutableSortedMap.Builder.emptyMap(DocumentKey.comparator());
    private final MemoryPersistence persistence;

    MemoryRemoteDocumentCache(MemoryPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public void add(MutableDocument document, SnapshotVersion readTime) {
        Assert.hardAssert(!readTime.equals(SnapshotVersion.NONE), "Cannot add document to the RemoteDocumentCache with a read time of zero", new Object[0]);
        this.docs = this.docs.insert((Object)document.getKey(), (Object)new Pair((Object)document.clone(), (Object)readTime));
        this.persistence.getIndexManager().addToCollectionParentIndex((ResourcePath)document.getKey().getPath().popLast());
    }

    @Override
    public void remove(DocumentKey key) {
        this.docs = this.docs.remove((Object)key);
    }

    @Override
    public MutableDocument get(DocumentKey key) {
        Pair entry = (Pair)this.docs.get((Object)key);
        return entry != null ? ((MutableDocument)entry.first).clone() : MutableDocument.newInvalidDocument(key);
    }

    @Override
    public Map<DocumentKey, MutableDocument> getAll(Iterable<DocumentKey> keys) {
        HashMap<DocumentKey, MutableDocument> result = new HashMap<DocumentKey, MutableDocument>();
        for (DocumentKey key : keys) {
            result.put(key, this.get(key));
        }
        return result;
    }

    @Override
    public ImmutableSortedMap<DocumentKey, MutableDocument> getAllDocumentsMatchingQuery(Query query, SnapshotVersion sinceReadTime) {
        Map.Entry entry;
        DocumentKey key;
        Assert.hardAssert(!query.isCollectionGroupQuery(), "CollectionGroup queries should be handled in LocalDocumentsView", new Object[0]);
        ImmutableSortedMap result = DocumentCollections.emptyMutableDocumentMap();
        ResourcePath queryPath = query.getPath();
        DocumentKey prefix = DocumentKey.fromPath((ResourcePath)((Object)queryPath.append("")));
        Iterator iterator = this.docs.iteratorFrom((Object)prefix);
        while (iterator.hasNext() && queryPath.isPrefixOf((key = (DocumentKey)(entry = (Map.Entry)iterator.next()).getKey()).getPath())) {
            SnapshotVersion readTime;
            MutableDocument doc = (MutableDocument)((Pair)entry.getValue()).first;
            if (!doc.isFoundDocument() || (readTime = (SnapshotVersion)((Pair)entry.getValue()).second).compareTo(sinceReadTime) <= 0 || !query.matches(doc)) continue;
            result = result.insert((Object)doc.getKey(), (Object)doc.clone());
        }
        return result;
    }

    Iterable<MutableDocument> getDocuments() {
        return new DocumentIterable();
    }

    long getByteSize(LocalSerializer serializer) {
        long count = 0L;
        for (MutableDocument doc : new DocumentIterable()) {
            count += (long)serializer.encodeMaybeDocument(doc).getSerializedSize();
        }
        return count;
    }

    private class DocumentIterable
    implements Iterable<MutableDocument> {
        private DocumentIterable() {
        }

        @Override
        @NonNull
        public Iterator<MutableDocument> iterator() {
            final Iterator iterator = MemoryRemoteDocumentCache.this.docs.iterator();
            return new Iterator<MutableDocument>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public MutableDocument next() {
                    return (MutableDocument)((Pair)((Map.Entry)iterator.next()).getValue()).first;
                }
            };
        }
    }
}

