/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import com.google.auto.value.AutoValue;
import com.google.firebase.firestore.model.AutoValue_FieldIndex_Segment;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.SnapshotVersion;
import java.util.ArrayList;
import java.util.List;

public final class FieldIndex {
    private final String collectionGroup;
    private final int indexId;
    private final List<Segment> segments;
    private final SnapshotVersion version;

    public FieldIndex(String collectionGroup, int indexId) {
        this.collectionGroup = collectionGroup;
        this.segments = new ArrayList<Segment>();
        this.indexId = indexId;
        this.version = SnapshotVersion.NONE;
    }

    public FieldIndex(String collectionId) {
        this(collectionId, -1);
    }

    FieldIndex(String collectionGroup, int indexId, List<Segment> segments, SnapshotVersion version) {
        this.collectionGroup = collectionGroup;
        this.segments = segments;
        this.indexId = indexId;
        this.version = version;
    }

    public String getCollectionGroup() {
        return this.collectionGroup;
    }

    public int getIndexId() {
        return this.indexId;
    }

    public Segment getSegment(int index) {
        return this.segments.get(index);
    }

    public int segmentCount() {
        return this.segments.size();
    }

    public SnapshotVersion getVersion() {
        return this.version;
    }

    public Iterable<Segment> getDirectionalSegments() {
        ArrayList<Segment> filteredSegments = new ArrayList<Segment>();
        for (Segment segment : this.segments) {
            if (!segment.getKind().equals((Object)Segment.Kind.ORDERED)) continue;
            filteredSegments.add(segment);
        }
        return filteredSegments;
    }

    public Iterable<Segment> getArraySegments() {
        ArrayList<Segment> filteredSegments = new ArrayList<Segment>();
        for (Segment segment : this.segments) {
            if (!segment.getKind().equals((Object)Segment.Kind.CONTAINS)) continue;
            filteredSegments.add(segment);
        }
        return filteredSegments;
    }

    public FieldIndex withAddedField(FieldPath fieldPath, Segment.Kind kind) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>(this.segments);
        newSegments.add(new AutoValue_FieldIndex_Segment(fieldPath, kind));
        return new FieldIndex(this.collectionGroup, this.indexId, newSegments, this.version);
    }

    public FieldIndex withVersion(SnapshotVersion version) {
        return new FieldIndex(this.collectionGroup, this.indexId, this.segments, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldIndex fieldIndex = (FieldIndex)o;
        if (!this.segments.equals(fieldIndex.segments)) {
            return false;
        }
        if (!this.version.equals(fieldIndex.version)) {
            return false;
        }
        return this.collectionGroup.equals(fieldIndex.collectionGroup);
    }

    public int hashCode() {
        int result = this.collectionGroup.hashCode();
        result = 31 * result + this.segments.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return String.format("FieldIndex{collectionGroup='%s', segments=%s, version=%s}", this.collectionGroup, this.segments, this.version);
    }

    @AutoValue
    public static abstract class Segment {
        public abstract FieldPath getFieldPath();

        public abstract Kind getKind();

        public String toString() {
            return String.format("Segment{fieldPath=%s, kind=%s}", new Object[]{this.getFieldPath(), this.getKind()});
        }

        public static enum Kind {
            ORDERED,
            CONTAINS;

        }
    }
}

