/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.DocumentOverlayCache;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalDocumentsResult;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.OverlayedDocument;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.model.mutation.Overlay;
import com.google.firebase.firestore.model.mutation.PatchMutation;
import com.google.firebase.firestore.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class LocalDocumentsView {
    private final RemoteDocumentCache remoteDocumentCache;
    private final MutationQueue mutationQueue;
    private final DocumentOverlayCache documentOverlayCache;
    private final IndexManager indexManager;

    LocalDocumentsView(RemoteDocumentCache remoteDocumentCache, MutationQueue mutationQueue, DocumentOverlayCache documentOverlayCache, IndexManager indexManager) {
        this.remoteDocumentCache = remoteDocumentCache;
        this.mutationQueue = mutationQueue;
        this.documentOverlayCache = documentOverlayCache;
        this.indexManager = indexManager;
    }

    @VisibleForTesting
    RemoteDocumentCache getRemoteDocumentCache() {
        return this.remoteDocumentCache;
    }

    @VisibleForTesting
    MutationQueue getMutationQueue() {
        return this.mutationQueue;
    }

    @VisibleForTesting
    DocumentOverlayCache getDocumentOverlayCache() {
        return this.documentOverlayCache;
    }

    Document getDocument(DocumentKey key) {
        Overlay overlay = this.documentOverlayCache.getOverlay(key);
        MutableDocument document = this.getBaseDocument(key, overlay);
        if (overlay != null) {
            overlay.getMutation().applyToLocalView(document, FieldMask.EMPTY, Timestamp.now());
        }
        return document;
    }

    ImmutableSortedMap<DocumentKey, Document> getDocuments(Iterable<DocumentKey> keys) {
        Map<DocumentKey, MutableDocument> docs = this.remoteDocumentCache.getAll(keys);
        return this.getLocalViewOfDocuments(docs, new HashSet<DocumentKey>());
    }

    ImmutableSortedMap<DocumentKey, Document> getLocalViewOfDocuments(Map<DocumentKey, MutableDocument> docs, Set<DocumentKey> existenceStateChanged) {
        HashMap<DocumentKey, Overlay> overlays = new HashMap<DocumentKey, Overlay>();
        this.populateOverlays(overlays, docs.keySet());
        ImmutableSortedMap result = DocumentCollections.emptyDocumentMap();
        for (Map.Entry<DocumentKey, OverlayedDocument> entry : this.computeViews(docs, overlays, existenceStateChanged).entrySet()) {
            result = result.insert((Object)entry.getKey(), (Object)entry.getValue().getDocument());
        }
        return result;
    }

    Map<DocumentKey, OverlayedDocument> getOverlayedDocuments(Map<DocumentKey, MutableDocument> docs) {
        HashMap<DocumentKey, Overlay> overlays = new HashMap<DocumentKey, Overlay>();
        this.populateOverlays(overlays, docs.keySet());
        return this.computeViews(docs, overlays, new HashSet<DocumentKey>());
    }

    private Map<DocumentKey, OverlayedDocument> computeViews(Map<DocumentKey, MutableDocument> docs, Map<DocumentKey, Overlay> overlays, Set<DocumentKey> existenceStateChanged) {
        HashMap<DocumentKey, MutableDocument> recalculateDocuments = new HashMap<DocumentKey, MutableDocument>();
        HashMap<DocumentKey, FieldMask> mutatedFields = new HashMap<DocumentKey, FieldMask>();
        for (MutableDocument doc : docs.values()) {
            Overlay overlay = overlays.get(doc.getKey());
            if (existenceStateChanged.contains(doc.getKey()) && (overlay == null || overlay.getMutation() instanceof PatchMutation)) {
                recalculateDocuments.put(doc.getKey(), doc);
                continue;
            }
            if (overlay == null) continue;
            mutatedFields.put(doc.getKey(), overlay.getMutation().getFieldMask());
            overlay.getMutation().applyToLocalView(doc, overlay.getMutation().getFieldMask(), Timestamp.now());
        }
        Map<DocumentKey, FieldMask> recalculatedFields = this.recalculateAndSaveOverlays(recalculateDocuments);
        mutatedFields.putAll(recalculatedFields);
        HashMap<DocumentKey, OverlayedDocument> result = new HashMap<DocumentKey, OverlayedDocument>();
        for (Map.Entry<DocumentKey, MutableDocument> entry : docs.entrySet()) {
            result.put(entry.getKey(), new OverlayedDocument(entry.getValue(), (FieldMask)mutatedFields.get(entry.getKey())));
        }
        return result;
    }

    private Map<DocumentKey, FieldMask> recalculateAndSaveOverlays(Map<DocumentKey, MutableDocument> docs) {
        List<MutationBatch> batches = this.mutationQueue.getAllMutationBatchesAffectingDocumentKeys(docs.keySet());
        HashMap<DocumentKey, FieldMask> masks = new HashMap<DocumentKey, FieldMask>();
        TreeMap documentsByBatchId = new TreeMap();
        for (MutationBatch batch : batches) {
            for (DocumentKey key : batch.getKeys()) {
                MutableDocument baseDoc = docs.get(key);
                if (baseDoc == null) continue;
                FieldMask mask = masks.containsKey(key) ? (FieldMask)masks.get(key) : FieldMask.EMPTY;
                mask = batch.applyToLocalView(baseDoc, mask);
                masks.put(key, mask);
                int batchId = batch.getBatchId();
                if (!documentsByBatchId.containsKey(batchId)) {
                    documentsByBatchId.put(batchId, new HashSet());
                }
                ((Set)documentsByBatchId.get(batchId)).add(key);
            }
        }
        HashSet<DocumentKey> processed = new HashSet<DocumentKey>();
        for (Map.Entry entry : documentsByBatchId.descendingMap().entrySet()) {
            HashMap<DocumentKey, Mutation> overlays = new HashMap<DocumentKey, Mutation>();
            for (DocumentKey key : (Set)entry.getValue()) {
                if (processed.contains(key)) continue;
                Mutation mutation = Mutation.calculateOverlayMutation(docs.get(key), (FieldMask)masks.get(key));
                if (mutation != null) {
                    overlays.put(key, mutation);
                }
                processed.add(key);
            }
            this.documentOverlayCache.saveOverlays((Integer)entry.getKey(), overlays);
        }
        return masks;
    }

    void recalculateAndSaveOverlays(Set<DocumentKey> documentKeys) {
        Map<DocumentKey, MutableDocument> docs = this.remoteDocumentCache.getAll(documentKeys);
        this.recalculateAndSaveOverlays(docs);
    }

    ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingQuery(Query query, FieldIndex.IndexOffset offset) {
        ResourcePath path = query.getPath();
        if (query.isDocumentQuery()) {
            return this.getDocumentsMatchingDocumentQuery(path);
        }
        if (query.isCollectionGroupQuery()) {
            return this.getDocumentsMatchingCollectionGroupQuery(query, offset);
        }
        return this.getDocumentsMatchingCollectionQuery(query, offset);
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingDocumentQuery(ResourcePath path) {
        ImmutableSortedMap result = DocumentCollections.emptyDocumentMap();
        Document doc = this.getDocument(DocumentKey.fromPath(path));
        if (doc.isFoundDocument()) {
            result = result.insert((Object)doc.getKey(), (Object)doc);
        }
        return result;
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingCollectionGroupQuery(Query query, FieldIndex.IndexOffset offset) {
        Assert.hardAssert(query.getPath().isEmpty(), "Currently we only support collection group queries at the root.", new Object[0]);
        String collectionId = query.getCollectionGroup();
        ImmutableSortedMap results = DocumentCollections.emptyDocumentMap();
        List<ResourcePath> parents = this.indexManager.getCollectionParents(collectionId);
        for (ResourcePath parent : parents) {
            Query collectionQuery = query.asCollectionQueryAtPath((ResourcePath)((Object)parent.append(collectionId)));
            ImmutableSortedMap<DocumentKey, Document> collectionResults = this.getDocumentsMatchingCollectionQuery(collectionQuery, offset);
            for (Map.Entry docEntry : collectionResults) {
                results = results.insert((Object)((DocumentKey)docEntry.getKey()), (Object)((Document)docEntry.getValue()));
            }
        }
        return results;
    }

    LocalDocumentsResult getNextDocuments(String collectionGroup, FieldIndex.IndexOffset offset, int count) {
        Map<DocumentKey, MutableDocument> docs = this.remoteDocumentCache.getAll(collectionGroup, offset, count);
        Map<DocumentKey, Overlay> overlays = count - docs.size() > 0 ? this.documentOverlayCache.getOverlays(collectionGroup, offset.getLargestBatchId(), count - docs.size()) : Collections.emptyMap();
        int largestBatchId = -1;
        for (Overlay overlay : overlays.values()) {
            if (!docs.containsKey(overlay.getKey())) {
                docs.put(overlay.getKey(), this.getBaseDocument(overlay.getKey(), overlay));
            }
            largestBatchId = Math.max(largestBatchId, overlay.getLargestBatchId());
        }
        this.populateOverlays(overlays, docs.keySet());
        Map<DocumentKey, OverlayedDocument> localDocs = this.computeViews(docs, overlays, Collections.emptySet());
        return LocalDocumentsResult.fromOverlayedDocuments(largestBatchId, localDocs);
    }

    private void populateOverlays(Map<DocumentKey, Overlay> overlays, Set<DocumentKey> keys) {
        TreeSet<DocumentKey> missingOverlays = new TreeSet<DocumentKey>();
        for (DocumentKey key : keys) {
            if (overlays.containsKey(key)) continue;
            missingOverlays.add(key);
        }
        overlays.putAll(this.documentOverlayCache.getOverlays(missingOverlays));
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingCollectionQuery(Query query, FieldIndex.IndexOffset offset) {
        Map<DocumentKey, MutableDocument> remoteDocuments = this.remoteDocumentCache.getAll(query.getPath(), offset);
        Map<DocumentKey, Overlay> overlays = this.documentOverlayCache.getOverlays(query.getPath(), offset.getLargestBatchId());
        for (Map.Entry<DocumentKey, Overlay> entry : overlays.entrySet()) {
            if (remoteDocuments.containsKey(entry.getKey())) continue;
            remoteDocuments.put(entry.getKey(), MutableDocument.newInvalidDocument(entry.getKey()));
        }
        ImmutableSortedMap results = DocumentCollections.emptyDocumentMap();
        for (Map.Entry<DocumentKey, MutableDocument> docEntry : remoteDocuments.entrySet()) {
            Overlay overlay = overlays.get(docEntry.getKey());
            if (overlay != null) {
                overlay.getMutation().applyToLocalView(docEntry.getValue(), FieldMask.EMPTY, Timestamp.now());
            }
            if (!query.matches(docEntry.getValue())) continue;
            results = results.insert((Object)docEntry.getKey(), (Object)docEntry.getValue());
        }
        return results;
    }

    private MutableDocument getBaseDocument(DocumentKey key, @Nullable Overlay overlay) {
        return overlay == null || overlay.getMutation() instanceof PatchMutation ? this.remoteDocumentCache.get(key) : MutableDocument.newInvalidDocument(key);
    }
}

