/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.content.Context;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.FirestoreCallCredentials;
import com.google.firebase.firestore.remote.GrpcCallProvider;
import com.google.firebase.firestore.remote.GrpcMetadataProvider;
import com.google.firebase.firestore.remote.IncomingStreamObserver;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Util;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;

public class FirestoreChannel {
    private static final Metadata.Key<String> X_GOOG_API_CLIENT_HEADER = Metadata.Key.of((String)"x-goog-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> RESOURCE_PREFIX_HEADER = Metadata.Key.of((String)"google-cloud-resource-prefix", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> X_GOOG_REQUEST_PARAMS_HEADER = Metadata.Key.of((String)"x-goog-request-params", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static volatile String clientLanguage = "gl-java/";
    private final AsyncQueue asyncQueue;
    private final CredentialsProvider<User> authProvider;
    private final CredentialsProvider<String> appCheckProvider;
    private final GrpcCallProvider callProvider;
    private final String resourcePrefixValue;
    private final GrpcMetadataProvider metadataProvider;

    FirestoreChannel(AsyncQueue asyncQueue, Context context, CredentialsProvider<User> authProvider, CredentialsProvider<String> appCheckProvider, DatabaseInfo databaseInfo, GrpcMetadataProvider metadataProvider) {
        this.asyncQueue = asyncQueue;
        this.metadataProvider = metadataProvider;
        this.authProvider = authProvider;
        this.appCheckProvider = appCheckProvider;
        FirestoreCallCredentials firestoreHeaders = new FirestoreCallCredentials(authProvider, appCheckProvider);
        this.callProvider = new GrpcCallProvider(asyncQueue, context, databaseInfo, firestoreHeaders);
        DatabaseId databaseId = databaseInfo.getDatabaseId();
        this.resourcePrefixValue = String.format("projects/%s/databases/%s", databaseId.getProjectId(), databaseId.getDatabaseId());
    }

    public void shutdown() {
        this.callProvider.shutdown();
    }

    <ReqT, RespT> ClientCall<ReqT, RespT> runBidiStreamingRpc(MethodDescriptor<ReqT, RespT> method, final IncomingStreamObserver<RespT> observer) {
        final ClientCall[] call = new ClientCall[]{null};
        final Task<ClientCall<ReqT, RespT>> clientCall = this.callProvider.createClientCall(method);
        clientCall.addOnCompleteListener(this.asyncQueue.getExecutor(), result -> {
            call[0] = (ClientCall)result.getResult();
            call[0].start(new ClientCall.Listener<RespT>(){

                public void onHeaders(Metadata headers) {
                    try {
                        observer.onHeaders(headers);
                    }
                    catch (Throwable t) {
                        FirestoreChannel.this.asyncQueue.panic(t);
                    }
                }

                public void onMessage(RespT message) {
                    try {
                        observer.onNext(message);
                        call[0].request(1);
                    }
                    catch (Throwable t) {
                        FirestoreChannel.this.asyncQueue.panic(t);
                    }
                }

                public void onClose(Status status, Metadata trailers) {
                    try {
                        observer.onClose(status);
                    }
                    catch (Throwable t) {
                        FirestoreChannel.this.asyncQueue.panic(t);
                    }
                }

                public void onReady() {
                }
            }, this.requestHeaders());
            observer.onOpen();
            call[0].request(1);
        });
        return new ForwardingClientCall<ReqT, RespT>(){

            protected ClientCall<ReqT, RespT> delegate() {
                Assert.hardAssert(call[0] != null, "ClientCall used before onOpen() callback", new Object[0]);
                return call[0];
            }

            public void halfClose() {
                if (call[0] == null) {
                    clientCall.addOnSuccessListener(FirestoreChannel.this.asyncQueue.getExecutor(), ClientCall::halfClose);
                } else {
                    super.halfClose();
                }
            }
        };
    }

    <ReqT, RespT> void runStreamingResponseRpc(MethodDescriptor<ReqT, RespT> method, ReqT request, final StreamingListener<RespT> callback) {
        this.callProvider.createClientCall(method).addOnCompleteListener(this.asyncQueue.getExecutor(), result -> {
            final ClientCall call = (ClientCall)result.getResult();
            call.start(new ClientCall.Listener<RespT>(){

                public void onMessage(RespT message) {
                    callback.onMessage(message);
                    call.request(1);
                }

                public void onClose(Status status, Metadata trailers) {
                    callback.onClose(status);
                }
            }, this.requestHeaders());
            call.request(1);
            call.sendMessage(request);
            call.halfClose();
        });
    }

    <ReqT, RespT> Task<RespT> runRpc(MethodDescriptor<ReqT, RespT> method, ReqT request) {
        final TaskCompletionSource tcs = new TaskCompletionSource();
        this.callProvider.createClientCall(method).addOnCompleteListener(this.asyncQueue.getExecutor(), result -> {
            ClientCall call = (ClientCall)result.getResult();
            call.start(new ClientCall.Listener<RespT>(){

                public void onMessage(RespT message) {
                    tcs.setResult(message);
                }

                public void onClose(Status status, Metadata trailers) {
                    if (status.isOk()) {
                        if (!tcs.getTask().isComplete()) {
                            tcs.setException((Exception)((Object)new FirebaseFirestoreException("Received onClose with status OK, but no message.", FirebaseFirestoreException.Code.INTERNAL)));
                        }
                    } else {
                        tcs.setException((Exception)((Object)FirestoreChannel.this.exceptionFromStatus(status)));
                    }
                }
            }, this.requestHeaders());
            call.request(2);
            call.sendMessage(request);
            call.halfClose();
        });
        return tcs.getTask();
    }

    private FirebaseFirestoreException exceptionFromStatus(Status status) {
        if (Datastore.isMissingSslCiphers(status)) {
            return new FirebaseFirestoreException("The Cloud Firestore client failed to establish a secure connection. This is likely a problem with your app, rather than with Cloud Firestore itself. See https://bit.ly/2XFpdma for instructions on how to enable TLS on Android 4.x devices.", FirebaseFirestoreException.Code.fromValue(status.getCode().value()), status.getCause());
        }
        return Util.exceptionFromStatus(status);
    }

    public void invalidateToken() {
        this.authProvider.invalidateToken();
        this.appCheckProvider.invalidateToken();
    }

    public static void setClientLanguage(String languageToken) {
        clientLanguage = languageToken;
    }

    private String getGoogApiClientValue() {
        return String.format("%s fire/%s grpc/", clientLanguage, "24.4.1");
    }

    private Metadata requestHeaders() {
        Metadata headers = new Metadata();
        headers.put(X_GOOG_API_CLIENT_HEADER, (Object)this.getGoogApiClientValue());
        headers.put(RESOURCE_PREFIX_HEADER, (Object)this.resourcePrefixValue);
        headers.put(X_GOOG_REQUEST_PARAMS_HEADER, (Object)this.resourcePrefixValue);
        if (this.metadataProvider != null) {
            this.metadataProvider.updateMetadata(headers);
        }
        return headers;
    }

    public static abstract class StreamingListener<T> {
        public void onMessage(T message) {
        }

        public void onClose(Status status) {
        }
    }
}

