/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.bundle;

import com.google.firebase.firestore.bundle.BundleElement;
import com.google.firebase.firestore.model.SnapshotVersion;

public class BundleMetadata
implements BundleElement {
    private final String bundleId;
    private final int schemaVersion;
    private final SnapshotVersion createTime;
    private final int totalDocuments;
    private final long totalBytes;

    public BundleMetadata(String bundleId, int schemaVersion, SnapshotVersion createTime, int totalDocuments, long totalBytes) {
        this.bundleId = bundleId;
        this.schemaVersion = schemaVersion;
        this.createTime = createTime;
        this.totalDocuments = totalDocuments;
        this.totalBytes = totalBytes;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public SnapshotVersion getCreateTime() {
        return this.createTime;
    }

    public int getTotalDocuments() {
        return this.totalDocuments;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleMetadata that = (BundleMetadata)o;
        if (this.schemaVersion != that.schemaVersion) {
            return false;
        }
        if (this.totalDocuments != that.totalDocuments) {
            return false;
        }
        if (this.totalBytes != that.totalBytes) {
            return false;
        }
        if (!this.bundleId.equals(that.bundleId)) {
            return false;
        }
        return this.createTime.equals(that.createTime);
    }

    public int hashCode() {
        int result = this.bundleId.hashCode();
        result = 31 * result + this.schemaVersion;
        result = 31 * result + this.totalDocuments;
        result = 31 * result + (int)(this.totalBytes ^ this.totalBytes >>> 32);
        result = 31 * result + this.createTime.hashCode();
        return result;
    }
}

