/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.AggregateQuerySnapshot;
import com.google.firebase.firestore.AggregateSource;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Preconditions;

public class AggregateQuery {
    private final Query query;

    AggregateQuery(@NonNull Query query) {
        this.query = query;
    }

    @NonNull
    public Query getQuery() {
        return this.query;
    }

    @NonNull
    public Task<AggregateQuerySnapshot> get(@NonNull AggregateSource source) {
        Preconditions.checkNotNull(source, "AggregateSource must not be null");
        TaskCompletionSource tcs = new TaskCompletionSource();
        this.query.firestore.getClient().runCountQuery(this.query.query).continueWith(Executors.DIRECT_EXECUTOR, task -> {
            if (task.isSuccessful()) {
                tcs.setResult((Object)new AggregateQuerySnapshot(this, (Long)task.getResult()));
            } else {
                tcs.setException(task.getException());
            }
            return null;
        });
        return tcs.getTask();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AggregateQuery)) {
            return false;
        }
        AggregateQuery other = (AggregateQuery)object;
        return this.query.equals(other.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }
}

