/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.AggregateQuery;
import com.google.firebase.firestore.util.Preconditions;
import java.util.Objects;

public class AggregateQuerySnapshot {
    private final long count;
    private final AggregateQuery query;

    AggregateQuerySnapshot(@NonNull AggregateQuery query, long count) {
        Preconditions.checkNotNull(query);
        this.query = query;
        this.count = count;
    }

    @NonNull
    public AggregateQuery getQuery() {
        return this.query;
    }

    public long getCount() {
        return this.count;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AggregateQuerySnapshot)) {
            return false;
        }
        AggregateQuerySnapshot other = (AggregateQuerySnapshot)object;
        return this.count == other.count && this.query.equals(other.query);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.query);
    }
}

