/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.core.CompositeFilter;
import com.google.firebase.firestore.core.FieldFilter;
import java.util.Arrays;
import java.util.List;

public class Filter {
    @NonNull
    public static Filter equalTo(@NonNull String field, @Nullable Object value) {
        return Filter.equalTo(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter equalTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.EQUAL, value);
    }

    @NonNull
    public static Filter notEqualTo(@NonNull String field, @Nullable Object value) {
        return Filter.notEqualTo(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter notEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.NOT_EQUAL, value);
    }

    @NonNull
    public static Filter greaterThan(@NonNull String field, @Nullable Object value) {
        return Filter.greaterThan(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter greaterThan(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.GREATER_THAN, value);
    }

    @NonNull
    public static Filter greaterThanOrEqualTo(@NonNull String field, @Nullable Object value) {
        return Filter.greaterThanOrEqualTo(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter greaterThanOrEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.GREATER_THAN_OR_EQUAL, value);
    }

    @NonNull
    public static Filter lessThan(@NonNull String field, @Nullable Object value) {
        return Filter.lessThan(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter lessThan(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.LESS_THAN, value);
    }

    @NonNull
    public static Filter lessThanOrEqualTo(@NonNull String field, @Nullable Object value) {
        return Filter.lessThanOrEqualTo(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter lessThanOrEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.LESS_THAN_OR_EQUAL, value);
    }

    @NonNull
    public static Filter arrayContains(@NonNull String field, @Nullable Object value) {
        return Filter.arrayContains(FieldPath.fromDotSeparatedPath(field), value);
    }

    @NonNull
    public static Filter arrayContains(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.ARRAY_CONTAINS, value);
    }

    @NonNull
    public static Filter arrayContainsAny(@NonNull String field, @NonNull List<? extends Object> values) {
        return Filter.arrayContainsAny(FieldPath.fromDotSeparatedPath(field), values);
    }

    @NonNull
    public static Filter arrayContainsAny(@NonNull FieldPath fieldPath, @NonNull List<? extends Object> values) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.ARRAY_CONTAINS_ANY, values);
    }

    @NonNull
    public static Filter inArray(@NonNull String field, @NonNull List<? extends Object> values) {
        return Filter.inArray(FieldPath.fromDotSeparatedPath(field), values);
    }

    @NonNull
    public static Filter inArray(@NonNull FieldPath fieldPath, @NonNull List<? extends Object> values) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.IN, values);
    }

    @NonNull
    public static Filter notInArray(@NonNull String field, @NonNull List<? extends Object> values) {
        return Filter.notInArray(FieldPath.fromDotSeparatedPath(field), values);
    }

    @NonNull
    public static Filter notInArray(@NonNull FieldPath fieldPath, @NonNull List<? extends Object> values) {
        return new UnaryFilter(fieldPath, FieldFilter.Operator.NOT_IN, values);
    }

    @NonNull
    public static Filter or(Filter ... filters) {
        return new CompositeFilter(Arrays.asList(filters), CompositeFilter.Operator.OR);
    }

    @NonNull
    public static Filter and(Filter ... filters) {
        return new CompositeFilter(Arrays.asList(filters), CompositeFilter.Operator.AND);
    }

    static class CompositeFilter
    extends Filter {
        private final List<Filter> filters;
        private final CompositeFilter.Operator operator;

        public CompositeFilter(@NonNull List<Filter> filters, CompositeFilter.Operator operator) {
            this.filters = filters;
            this.operator = operator;
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public CompositeFilter.Operator getOperator() {
            return this.operator;
        }
    }

    static class UnaryFilter
    extends Filter {
        private final FieldPath field;
        private final FieldFilter.Operator operator;
        private final Object value;

        public UnaryFilter(FieldPath field, FieldFilter.Operator operator, @Nullable Object value) {
            this.field = field;
            this.operator = operator;
            this.value = value;
        }

        public FieldPath getField() {
            return this.field;
        }

        public FieldFilter.Operator getOperator() {
            return this.operator;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }
    }
}

