/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

class ThrottledForwardingExecutor
implements Executor {
    private final Executor executor;
    private final Semaphore availableSlots;

    ThrottledForwardingExecutor(int maximumConcurrency, Executor executor) {
        this.availableSlots = new Semaphore(maximumConcurrency);
        this.executor = executor;
    }

    @Override
    public void execute(Runnable command) {
        if (this.availableSlots.tryAcquire()) {
            try {
                this.executor.execute(() -> {
                    command.run();
                    this.availableSlots.release();
                });
            }
            catch (RejectedExecutionException e) {
                command.run();
            }
        } else {
            command.run();
        }
    }
}

