/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.LocalCacheSettings;
import com.google.firebase.firestore.MemoryCacheSettings;
import com.google.firebase.firestore.MemoryLruGcSettings;
import com.google.firebase.firestore.PersistentCacheSettings;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FirebaseFirestoreSettings {
    public static final long CACHE_SIZE_UNLIMITED = -1L;
    public static final String DEFAULT_HOST = "firestore.googleapis.com";
    static final long MINIMUM_CACHE_BYTES = 0x100000L;
    static final long DEFAULT_CACHE_SIZE_BYTES = 0x6400000L;
    private final String host;
    private final boolean sslEnabled;
    private final boolean persistenceEnabled;
    private final long cacheSizeBytes;
    private LocalCacheSettings cacheSettings;

    private FirebaseFirestoreSettings(Builder builder) {
        this.host = builder.host;
        this.sslEnabled = builder.sslEnabled;
        this.persistenceEnabled = builder.persistenceEnabled;
        this.cacheSizeBytes = builder.cacheSizeBytes;
        this.cacheSettings = builder.cacheSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirebaseFirestoreSettings that = (FirebaseFirestoreSettings)o;
        if (this.sslEnabled != that.sslEnabled) {
            return false;
        }
        if (this.persistenceEnabled != that.persistenceEnabled) {
            return false;
        }
        if (this.cacheSizeBytes != that.cacheSizeBytes) {
            return false;
        }
        if (!this.host.equals(that.host)) {
            return false;
        }
        return Objects.equals(this.cacheSettings, that.cacheSettings);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + (this.sslEnabled ? 1 : 0);
        result = 31 * result + (this.persistenceEnabled ? 1 : 0);
        result = 31 * result + (int)(this.cacheSizeBytes ^ this.cacheSizeBytes >>> 32);
        result = 31 * result + (this.cacheSettings != null ? this.cacheSettings.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return "FirebaseFirestoreSettings{host=" + this.host + ", sslEnabled=" + this.sslEnabled + ", persistenceEnabled=" + this.persistenceEnabled + ", cacheSizeBytes=" + this.cacheSizeBytes + ", cacheSettings=" + this.cacheSettings == null ? "null" : this.cacheSettings.toString() + "}";
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    @Deprecated
    public boolean isPersistenceEnabled() {
        if (this.cacheSettings != null) {
            return this.cacheSettings instanceof PersistentCacheSettings;
        }
        return this.persistenceEnabled;
    }

    @Deprecated
    public long getCacheSizeBytes() {
        if (this.cacheSettings != null) {
            if (this.cacheSettings instanceof PersistentCacheSettings) {
                return ((PersistentCacheSettings)this.cacheSettings).getSizeBytes();
            }
            MemoryCacheSettings memorySettings = (MemoryCacheSettings)this.cacheSettings;
            if (memorySettings.getGarbageCollectorSettings() instanceof MemoryLruGcSettings) {
                return ((MemoryLruGcSettings)memorySettings.getGarbageCollectorSettings()).getSizeBytes();
            }
            return -1L;
        }
        return this.cacheSizeBytes;
    }

    @Nullable
    public LocalCacheSettings getCacheSettings() {
        return this.cacheSettings;
    }

    public static final class Builder {
        private String host;
        private boolean sslEnabled;
        private boolean persistenceEnabled;
        private long cacheSizeBytes;
        private LocalCacheSettings cacheSettings;
        private boolean usedLegacyCacheSettings = false;

        public Builder() {
            this.host = FirebaseFirestoreSettings.DEFAULT_HOST;
            this.sslEnabled = true;
            this.persistenceEnabled = true;
            this.cacheSizeBytes = 0x6400000L;
        }

        public Builder(@NonNull FirebaseFirestoreSettings settings) {
            Preconditions.checkNotNull(settings, "Provided settings must not be null.");
            this.host = settings.host;
            this.sslEnabled = settings.sslEnabled;
            this.persistenceEnabled = settings.persistenceEnabled;
            this.cacheSizeBytes = settings.cacheSizeBytes;
            if (!this.persistenceEnabled || this.cacheSizeBytes != 0x6400000L) {
                this.usedLegacyCacheSettings = true;
            }
            if (!this.usedLegacyCacheSettings) {
                this.cacheSettings = settings.cacheSettings;
            } else {
                Assert.hardAssert(settings.cacheSettings == null, "Given settings object mixes both cache config APIs, which is impossible.", new Object[0]);
            }
        }

        @NonNull
        public Builder setHost(@NonNull String host) {
            this.host = Preconditions.checkNotNull(host, "Provided host must not be null.");
            return this;
        }

        @NonNull
        public Builder setSslEnabled(boolean value) {
            this.sslEnabled = value;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setPersistenceEnabled(boolean value) {
            if (this.cacheSettings != null) {
                throw new IllegalStateException("New cache config API setLocalCacheSettings() is already used.");
            }
            this.persistenceEnabled = value;
            this.usedLegacyCacheSettings = true;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setCacheSizeBytes(long value) {
            if (this.cacheSettings != null) {
                throw new IllegalStateException("New cache config API setLocalCacheSettings() is already used.");
            }
            if (value != -1L && value < 0x100000L) {
                throw new IllegalArgumentException("Cache size must be set to at least 1048576 bytes");
            }
            this.cacheSizeBytes = value;
            this.usedLegacyCacheSettings = true;
            return this;
        }

        @NonNull
        public Builder setLocalCacheSettings(@NonNull LocalCacheSettings settings) {
            if (this.usedLegacyCacheSettings) {
                throw new IllegalStateException("Deprecated setPersistenceEnabled() or setCacheSizeBytes() is already used, remove those first.");
            }
            if (!(settings instanceof MemoryCacheSettings) && !(settings instanceof PersistentCacheSettings)) {
                throw new IllegalArgumentException("Only MemoryCacheSettings and PersistentCacheSettings are accepted");
            }
            this.cacheSettings = settings;
            return this;
        }

        @NonNull
        public String getHost() {
            return this.host;
        }

        public boolean isSslEnabled() {
            return this.sslEnabled;
        }

        @Deprecated
        public boolean isPersistenceEnabled() {
            return this.persistenceEnabled;
        }

        @Deprecated
        public long getCacheSizeBytes() {
            return this.cacheSizeBytes;
        }

        @NonNull
        public FirebaseFirestoreSettings build() {
            if (!this.sslEnabled && this.host.equals(FirebaseFirestoreSettings.DEFAULT_HOST)) {
                throw new IllegalStateException("You can't set the 'sslEnabled' setting unless you also set a non-default 'host'.");
            }
            return new FirebaseFirestoreSettings(this);
        }
    }
}

