/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;

public final class TransactionOptions {
    static final TransactionOptions DEFAULT = new Builder().build();
    static final int DEFAULT_MAX_ATTEMPTS_COUNT = 5;
    private final int maxAttempts;

    private TransactionOptions(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOptions that = (TransactionOptions)o;
        return this.maxAttempts == that.maxAttempts;
    }

    public int hashCode() {
        return this.maxAttempts;
    }

    public String toString() {
        return "TransactionOptions{maxAttempts=" + this.maxAttempts + '}';
    }

    public static final class Builder {
        private int maxAttempts = 5;

        public Builder() {
        }

        public Builder(@NonNull TransactionOptions options) {
            this.maxAttempts = options.maxAttempts;
        }

        @NonNull
        public Builder setMaxAttempts(int maxAttempts) {
            if (maxAttempts < 1) {
                throw new IllegalArgumentException("Max attempts must be at least 1");
            }
            this.maxAttempts = maxAttempts;
            return this;
        }

        @NonNull
        public TransactionOptions build() {
            return new TransactionOptions(this.maxAttempts);
        }
    }
}

