/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.model.Document;

public class DocumentViewChange {
    private final Type type;
    private final Document document;

    public static DocumentViewChange create(Type type, Document document) {
        return new DocumentViewChange(type, document);
    }

    private DocumentViewChange(Type type, Document document) {
        this.type = type;
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocumentViewChange)) {
            return false;
        }
        DocumentViewChange other = (DocumentViewChange)o;
        return this.type.equals((Object)other.type) && this.document.equals(other.document);
    }

    public int hashCode() {
        int res = 61;
        res = res * 31 + this.type.hashCode();
        res = res * 31 + this.document.getKey().hashCode();
        res = res * 31 + this.document.getData().hashCode();
        return res;
    }

    public String toString() {
        return "DocumentViewChange(" + this.document + "," + (Object)((Object)this.type) + ")";
    }

    public static enum Type {
        REMOVED,
        ADDED,
        MODIFIED,
        METADATA;

    }
}

