/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.AggregateField;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.CompositeFilter;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.local.TargetData;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.model.mutation.ArrayTransformOperation;
import com.google.firebase.firestore.model.mutation.DeleteMutation;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.NumericIncrementTransformOperation;
import com.google.firebase.firestore.model.mutation.PatchMutation;
import com.google.firebase.firestore.model.mutation.ServerTimestampOperation;
import com.google.firebase.firestore.model.mutation.SetMutation;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.model.mutation.VerifyMutation;
import com.google.firebase.firestore.remote.ExistenceFilter;
import com.google.firebase.firestore.remote.WatchChange;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentChange;
import com.google.firestore.v1.DocumentDelete;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.DocumentRemove;
import com.google.firestore.v1.DocumentTransform;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.StructuredAggregationQuery;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Target;
import com.google.firestore.v1.TargetChange;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import com.google.firestore.v1.WriteResult;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class RemoteSerializer {
    private final DatabaseId databaseId;
    private final String databaseName;

    public RemoteSerializer(DatabaseId databaseId) {
        this.databaseId = databaseId;
        this.databaseName = RemoteSerializer.encodedDatabaseId(databaseId).canonicalString();
    }

    public com.google.protobuf.Timestamp encodeTimestamp(Timestamp timestamp) {
        Timestamp.Builder builder = com.google.protobuf.Timestamp.newBuilder();
        builder.setSeconds(timestamp.getSeconds());
        builder.setNanos(timestamp.getNanoseconds());
        return (com.google.protobuf.Timestamp)builder.build();
    }

    public Timestamp decodeTimestamp(com.google.protobuf.Timestamp proto) {
        return new Timestamp(proto.getSeconds(), proto.getNanos());
    }

    public com.google.protobuf.Timestamp encodeVersion(SnapshotVersion version) {
        return this.encodeTimestamp(version.getTimestamp());
    }

    public SnapshotVersion decodeVersion(com.google.protobuf.Timestamp proto) {
        if (proto.getSeconds() == 0L && proto.getNanos() == 0) {
            return SnapshotVersion.NONE;
        }
        return new SnapshotVersion(this.decodeTimestamp(proto));
    }

    public String encodeKey(DocumentKey key) {
        return this.encodeResourceName(this.databaseId, key.getPath());
    }

    public DocumentKey decodeKey(String name) {
        ResourcePath resource = this.decodeResourceName(name);
        Assert.hardAssert(resource.getSegment(1).equals(this.databaseId.getProjectId()), "Tried to deserialize key from different project.", new Object[0]);
        Assert.hardAssert(resource.getSegment(3).equals(this.databaseId.getDatabaseId()), "Tried to deserialize key from different database.", new Object[0]);
        return DocumentKey.fromPath(RemoteSerializer.extractLocalPathFromResourceName(resource));
    }

    private String encodeQueryPath(ResourcePath path) {
        return this.encodeResourceName(this.databaseId, path);
    }

    private ResourcePath decodeQueryPath(String name) {
        ResourcePath resource = this.decodeResourceName(name);
        if (resource.length() == 4) {
            return ResourcePath.EMPTY;
        }
        return RemoteSerializer.extractLocalPathFromResourceName(resource);
    }

    private String encodeResourceName(DatabaseId databaseId, ResourcePath path) {
        return ((ResourcePath)((Object)RemoteSerializer.encodedDatabaseId(databaseId).append("documents"))).append(path).canonicalString();
    }

    private ResourcePath decodeResourceName(String encoded) {
        ResourcePath resource = ResourcePath.fromString(encoded);
        Assert.hardAssert(RemoteSerializer.isValidResourceName(resource), "Tried to deserialize invalid key %s", resource);
        return resource;
    }

    private static ResourcePath encodedDatabaseId(DatabaseId databaseId) {
        return ResourcePath.fromSegments(Arrays.asList("projects", databaseId.getProjectId(), "databases", databaseId.getDatabaseId()));
    }

    private static ResourcePath extractLocalPathFromResourceName(ResourcePath resourceName) {
        Assert.hardAssert(resourceName.length() > 4 && resourceName.getSegment(4).equals("documents"), "Tried to deserialize invalid key %s", resourceName);
        return (ResourcePath)resourceName.popFirst(5);
    }

    private static boolean isValidResourceName(ResourcePath path) {
        return path.length() >= 4 && path.getSegment(0).equals("projects") && path.getSegment(2).equals("databases");
    }

    public boolean isLocalResourceName(ResourcePath path) {
        return RemoteSerializer.isValidResourceName(path) && path.getSegment(1).equals(this.databaseId.getProjectId()) && path.getSegment(3).equals(this.databaseId.getDatabaseId());
    }

    public String databaseName() {
        return this.databaseName;
    }

    public Document encodeDocument(DocumentKey key, ObjectValue value) {
        Document.Builder builder = Document.newBuilder();
        builder.setName(this.encodeKey(key));
        builder.putAllFields(value.getFieldsMap());
        return (Document)builder.build();
    }

    public MutableDocument decodeMaybeDocument(BatchGetDocumentsResponse response) {
        if (response.getResultCase().equals((Object)BatchGetDocumentsResponse.ResultCase.FOUND)) {
            return this.decodeFoundDocument(response);
        }
        if (response.getResultCase().equals((Object)BatchGetDocumentsResponse.ResultCase.MISSING)) {
            return this.decodeMissingDocument(response);
        }
        throw new IllegalArgumentException("Unknown result case: " + (Object)((Object)response.getResultCase()));
    }

    private MutableDocument decodeFoundDocument(BatchGetDocumentsResponse response) {
        Assert.hardAssert(response.getResultCase().equals((Object)BatchGetDocumentsResponse.ResultCase.FOUND), "Tried to deserialize a found document from a missing document.", new Object[0]);
        DocumentKey key = this.decodeKey(response.getFound().getName());
        ObjectValue value = ObjectValue.fromMap(response.getFound().getFieldsMap());
        SnapshotVersion version = this.decodeVersion(response.getFound().getUpdateTime());
        Assert.hardAssert(!version.equals(SnapshotVersion.NONE), "Got a document response with no snapshot version", new Object[0]);
        return MutableDocument.newFoundDocument(key, version, value);
    }

    private MutableDocument decodeMissingDocument(BatchGetDocumentsResponse response) {
        Assert.hardAssert(response.getResultCase().equals((Object)BatchGetDocumentsResponse.ResultCase.MISSING), "Tried to deserialize a missing document from a found document.", new Object[0]);
        DocumentKey key = this.decodeKey(response.getMissing());
        SnapshotVersion version = this.decodeVersion(response.getReadTime());
        Assert.hardAssert(!version.equals(SnapshotVersion.NONE), "Got a no document response with no snapshot version", new Object[0]);
        return MutableDocument.newNoDocument(key, version);
    }

    public Write encodeMutation(Mutation mutation) {
        Write.Builder builder = Write.newBuilder();
        if (mutation instanceof SetMutation) {
            builder.setUpdate(this.encodeDocument(mutation.getKey(), ((SetMutation)mutation).getValue()));
        } else if (mutation instanceof PatchMutation) {
            builder.setUpdate(this.encodeDocument(mutation.getKey(), ((PatchMutation)mutation).getValue()));
            builder.setUpdateMask(this.encodeDocumentMask(mutation.getFieldMask()));
        } else if (mutation instanceof DeleteMutation) {
            builder.setDelete(this.encodeKey(mutation.getKey()));
        } else if (mutation instanceof VerifyMutation) {
            builder.setVerify(this.encodeKey(mutation.getKey()));
        } else {
            throw Assert.fail("unknown mutation type %s", mutation.getClass());
        }
        for (FieldTransform fieldTransform : mutation.getFieldTransforms()) {
            builder.addUpdateTransforms(this.encodeFieldTransform(fieldTransform));
        }
        if (!mutation.getPrecondition().isNone()) {
            builder.setCurrentDocument(this.encodePrecondition(mutation.getPrecondition()));
        }
        return (Write)builder.build();
    }

    public Mutation decodeMutation(Write mutation) {
        com.google.firebase.firestore.model.mutation.Precondition precondition = mutation.hasCurrentDocument() ? this.decodePrecondition(mutation.getCurrentDocument()) : com.google.firebase.firestore.model.mutation.Precondition.NONE;
        ArrayList<FieldTransform> fieldTransforms = new ArrayList<FieldTransform>();
        for (DocumentTransform.FieldTransform fieldTransform : mutation.getUpdateTransformsList()) {
            fieldTransforms.add(this.decodeFieldTransform(fieldTransform));
        }
        switch (mutation.getOperationCase()) {
            case UPDATE: {
                if (mutation.hasUpdateMask()) {
                    return new PatchMutation(this.decodeKey(mutation.getUpdate().getName()), ObjectValue.fromMap(mutation.getUpdate().getFieldsMap()), this.decodeDocumentMask(mutation.getUpdateMask()), precondition, fieldTransforms);
                }
                return new SetMutation(this.decodeKey(mutation.getUpdate().getName()), ObjectValue.fromMap(mutation.getUpdate().getFieldsMap()), precondition, fieldTransforms);
            }
            case DELETE: {
                return new DeleteMutation(this.decodeKey(mutation.getDelete()), precondition);
            }
            case VERIFY: {
                return new VerifyMutation(this.decodeKey(mutation.getVerify()), precondition);
            }
        }
        throw Assert.fail("Unknown mutation operation: %d", new Object[]{mutation.getOperationCase()});
    }

    private Precondition encodePrecondition(com.google.firebase.firestore.model.mutation.Precondition precondition) {
        Assert.hardAssert(!precondition.isNone(), "Can't serialize an empty precondition", new Object[0]);
        Precondition.Builder builder = Precondition.newBuilder();
        if (precondition.getUpdateTime() != null) {
            return (Precondition)builder.setUpdateTime(this.encodeVersion(precondition.getUpdateTime())).build();
        }
        if (precondition.getExists() != null) {
            return (Precondition)builder.setExists(precondition.getExists()).build();
        }
        throw Assert.fail("Unknown Precondition", new Object[0]);
    }

    private com.google.firebase.firestore.model.mutation.Precondition decodePrecondition(Precondition precondition) {
        switch (precondition.getConditionTypeCase()) {
            case UPDATE_TIME: {
                return com.google.firebase.firestore.model.mutation.Precondition.updateTime(this.decodeVersion(precondition.getUpdateTime()));
            }
            case EXISTS: {
                return com.google.firebase.firestore.model.mutation.Precondition.exists(precondition.getExists());
            }
            case CONDITIONTYPE_NOT_SET: {
                return com.google.firebase.firestore.model.mutation.Precondition.NONE;
            }
        }
        throw Assert.fail("Unknown precondition", new Object[0]);
    }

    private DocumentMask encodeDocumentMask(FieldMask mask) {
        DocumentMask.Builder builder = DocumentMask.newBuilder();
        for (FieldPath path : mask.getMask()) {
            builder.addFieldPaths(path.canonicalString());
        }
        return (DocumentMask)builder.build();
    }

    private FieldMask decodeDocumentMask(DocumentMask mask) {
        int count = mask.getFieldPathsCount();
        HashSet<FieldPath> paths = new HashSet<FieldPath>(count);
        for (int i = 0; i < count; ++i) {
            paths.add(FieldPath.fromServerFormat(mask.getFieldPaths(i)));
        }
        return FieldMask.fromSet(paths);
    }

    private DocumentTransform.FieldTransform encodeFieldTransform(FieldTransform fieldTransform) {
        TransformOperation transform = fieldTransform.getOperation();
        if (transform instanceof ServerTimestampOperation) {
            return (DocumentTransform.FieldTransform)DocumentTransform.FieldTransform.newBuilder().setFieldPath(fieldTransform.getFieldPath().canonicalString()).setSetToServerValue(DocumentTransform.FieldTransform.ServerValue.REQUEST_TIME).build();
        }
        if (transform instanceof ArrayTransformOperation.Union) {
            ArrayTransformOperation.Union union = (ArrayTransformOperation.Union)transform;
            return (DocumentTransform.FieldTransform)DocumentTransform.FieldTransform.newBuilder().setFieldPath(fieldTransform.getFieldPath().canonicalString()).setAppendMissingElements(ArrayValue.newBuilder().addAllValues(union.getElements())).build();
        }
        if (transform instanceof ArrayTransformOperation.Remove) {
            ArrayTransformOperation.Remove remove = (ArrayTransformOperation.Remove)transform;
            return (DocumentTransform.FieldTransform)DocumentTransform.FieldTransform.newBuilder().setFieldPath(fieldTransform.getFieldPath().canonicalString()).setRemoveAllFromArray(ArrayValue.newBuilder().addAllValues(remove.getElements())).build();
        }
        if (transform instanceof NumericIncrementTransformOperation) {
            NumericIncrementTransformOperation incrementOperation = (NumericIncrementTransformOperation)transform;
            return (DocumentTransform.FieldTransform)DocumentTransform.FieldTransform.newBuilder().setFieldPath(fieldTransform.getFieldPath().canonicalString()).setIncrement(incrementOperation.getOperand()).build();
        }
        throw Assert.fail("Unknown transform: %s", transform);
    }

    private FieldTransform decodeFieldTransform(DocumentTransform.FieldTransform fieldTransform) {
        switch (fieldTransform.getTransformTypeCase()) {
            case SET_TO_SERVER_VALUE: {
                Assert.hardAssert(fieldTransform.getSetToServerValue() == DocumentTransform.FieldTransform.ServerValue.REQUEST_TIME, "Unknown transform setToServerValue: %s", new Object[]{fieldTransform.getSetToServerValue()});
                return new FieldTransform(FieldPath.fromServerFormat(fieldTransform.getFieldPath()), ServerTimestampOperation.getInstance());
            }
            case APPEND_MISSING_ELEMENTS: {
                return new FieldTransform(FieldPath.fromServerFormat(fieldTransform.getFieldPath()), new ArrayTransformOperation.Union(fieldTransform.getAppendMissingElements().getValuesList()));
            }
            case REMOVE_ALL_FROM_ARRAY: {
                return new FieldTransform(FieldPath.fromServerFormat(fieldTransform.getFieldPath()), new ArrayTransformOperation.Remove(fieldTransform.getRemoveAllFromArray().getValuesList()));
            }
            case INCREMENT: {
                return new FieldTransform(FieldPath.fromServerFormat(fieldTransform.getFieldPath()), new NumericIncrementTransformOperation(fieldTransform.getIncrement()));
            }
        }
        throw Assert.fail("Unknown FieldTransform proto: %s", fieldTransform);
    }

    public MutationResult decodeMutationResult(WriteResult proto, SnapshotVersion commitVersion) {
        SnapshotVersion version = this.decodeVersion(proto.getUpdateTime());
        if (SnapshotVersion.NONE.equals(version)) {
            version = commitVersion;
        }
        int transformResultsCount = proto.getTransformResultsCount();
        ArrayList<Value> transformResults = new ArrayList<Value>(transformResultsCount);
        for (int i = 0; i < transformResultsCount; ++i) {
            transformResults.add(proto.getTransformResults(i));
        }
        return new MutationResult(version, transformResults);
    }

    @Nullable
    public Map<String, String> encodeListenRequestLabels(TargetData targetData) {
        String value = this.encodeLabel(targetData.getPurpose());
        if (value == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(1);
        result.put("goog-listen-tags", value);
        return result;
    }

    @Nullable
    private String encodeLabel(QueryPurpose purpose) {
        switch (purpose) {
            case LISTEN: {
                return null;
            }
            case EXISTENCE_FILTER_MISMATCH: {
                return "existence-filter-mismatch";
            }
            case EXISTENCE_FILTER_MISMATCH_BLOOM: {
                return "existence-filter-mismatch-bloom";
            }
            case LIMBO_RESOLUTION: {
                return "limbo-document";
            }
        }
        throw Assert.fail("Unrecognized query purpose: %s", new Object[]{purpose});
    }

    public Target encodeTarget(TargetData targetData) {
        Target.Builder builder = Target.newBuilder();
        com.google.firebase.firestore.core.Target target = targetData.getTarget();
        if (target.isDocumentQuery()) {
            builder.setDocuments(this.encodeDocumentsTarget(target));
        } else {
            builder.setQuery(this.encodeQueryTarget(target));
        }
        builder.setTargetId(targetData.getTargetId());
        if (targetData.getResumeToken().isEmpty() && targetData.getSnapshotVersion().compareTo(SnapshotVersion.NONE) > 0) {
            builder.setReadTime(this.encodeTimestamp(targetData.getSnapshotVersion().getTimestamp()));
        } else {
            builder.setResumeToken(targetData.getResumeToken());
        }
        if (!(targetData.getExpectedCount() == null || targetData.getResumeToken().isEmpty() && targetData.getSnapshotVersion().compareTo(SnapshotVersion.NONE) <= 0)) {
            builder.setExpectedCount(Int32Value.newBuilder().setValue(targetData.getExpectedCount().intValue()));
        }
        return (Target)builder.build();
    }

    public Target.DocumentsTarget encodeDocumentsTarget(com.google.firebase.firestore.core.Target target) {
        Target.DocumentsTarget.Builder builder = Target.DocumentsTarget.newBuilder();
        builder.addDocuments(this.encodeQueryPath(target.getPath()));
        return (Target.DocumentsTarget)builder.build();
    }

    public com.google.firebase.firestore.core.Target decodeDocumentsTarget(Target.DocumentsTarget target) {
        int count = target.getDocumentsCount();
        Assert.hardAssert(count == 1, "DocumentsTarget contained other than 1 document %d", count);
        String name = target.getDocuments(0);
        return Query.atPath(this.decodeQueryPath(name)).toTarget();
    }

    public Target.QueryTarget encodeQueryTarget(com.google.firebase.firestore.core.Target target) {
        Cursor.Builder cursor;
        Object from;
        Target.QueryTarget.Builder builder = Target.QueryTarget.newBuilder();
        StructuredQuery.Builder structuredQueryBuilder = StructuredQuery.newBuilder();
        ResourcePath path = target.getPath();
        if (target.getCollectionGroup() != null) {
            Assert.hardAssert(path.length() % 2 == 0, "Collection Group queries should be within a document path or root.", new Object[0]);
            builder.setParent(this.encodeQueryPath(path));
            from = StructuredQuery.CollectionSelector.newBuilder();
            ((StructuredQuery.CollectionSelector.Builder)from).setCollectionId(target.getCollectionGroup());
            ((StructuredQuery.CollectionSelector.Builder)from).setAllDescendants(true);
            structuredQueryBuilder.addFrom((StructuredQuery.CollectionSelector.Builder)from);
        } else {
            Assert.hardAssert(path.length() % 2 != 0, "Document queries with filters are not supported.", new Object[0]);
            builder.setParent(this.encodeQueryPath((ResourcePath)path.popLast()));
            from = StructuredQuery.CollectionSelector.newBuilder();
            ((StructuredQuery.CollectionSelector.Builder)from).setCollectionId(path.getLastSegment());
            structuredQueryBuilder.addFrom((StructuredQuery.CollectionSelector.Builder)from);
        }
        if (target.getFilters().size() > 0) {
            structuredQueryBuilder.setWhere(this.encodeFilters(target.getFilters()));
        }
        for (OrderBy orderBy : target.getOrderBy()) {
            structuredQueryBuilder.addOrderBy(this.encodeOrderBy(orderBy));
        }
        if (target.hasLimit()) {
            structuredQueryBuilder.setLimit(Int32Value.newBuilder().setValue((int)target.getLimit()));
        }
        if (target.getStartAt() != null) {
            cursor = Cursor.newBuilder();
            cursor.addAllValues(target.getStartAt().getPosition());
            cursor.setBefore(target.getStartAt().isInclusive());
            structuredQueryBuilder.setStartAt(cursor);
        }
        if (target.getEndAt() != null) {
            cursor = Cursor.newBuilder();
            cursor.addAllValues(target.getEndAt().getPosition());
            cursor.setBefore(!target.getEndAt().isInclusive());
            structuredQueryBuilder.setEndAt(cursor);
        }
        builder.setStructuredQuery(structuredQueryBuilder);
        return (Target.QueryTarget)builder.build();
    }

    public com.google.firebase.firestore.core.Target decodeQueryTarget(String parent, StructuredQuery query) {
        List<OrderBy> orderBy;
        ResourcePath path = this.decodeQueryPath(parent);
        String collectionGroup = null;
        int fromCount = query.getFromCount();
        if (fromCount > 0) {
            Assert.hardAssert(fromCount == 1, "StructuredQuery.from with more than one collection is not supported.", new Object[0]);
            StructuredQuery.CollectionSelector from = query.getFrom(0);
            if (from.getAllDescendants()) {
                collectionGroup = from.getCollectionId();
            } else {
                path = (ResourcePath)((Object)path.append(from.getCollectionId()));
            }
        }
        List<Filter> filterBy = query.hasWhere() ? this.decodeFilters(query.getWhere()) : Collections.emptyList();
        int orderByCount = query.getOrderByCount();
        if (orderByCount > 0) {
            orderBy = new ArrayList(orderByCount);
            for (int i = 0; i < orderByCount; ++i) {
                orderBy.add(this.decodeOrderBy(query.getOrderBy(i)));
            }
        } else {
            orderBy = Collections.emptyList();
        }
        long limit = -1L;
        if (query.hasLimit()) {
            limit = query.getLimit().getValue();
        }
        Bound startAt = null;
        if (query.hasStartAt()) {
            startAt = new Bound(query.getStartAt().getValuesList(), query.getStartAt().getBefore());
        }
        Bound endAt = null;
        if (query.hasEndAt()) {
            endAt = new Bound(query.getEndAt().getValuesList(), !query.getEndAt().getBefore());
        }
        return new com.google.firebase.firestore.core.Target(path, collectionGroup, filterBy, orderBy, limit, startAt, endAt);
    }

    public com.google.firebase.firestore.core.Target decodeQueryTarget(Target.QueryTarget target) {
        return this.decodeQueryTarget(target.getParent(), target.getStructuredQuery());
    }

    StructuredAggregationQuery encodeStructuredAggregationQuery(Target.QueryTarget encodedQueryTarget, List<AggregateField> aggregateFields, HashMap<String, String> aliasMap) {
        StructuredAggregationQuery.Builder structuredAggregationQuery = StructuredAggregationQuery.newBuilder();
        structuredAggregationQuery.setStructuredQuery(encodedQueryTarget.getStructuredQuery());
        ArrayList<StructuredAggregationQuery.Aggregation> aggregations = new ArrayList<StructuredAggregationQuery.Aggregation>();
        HashSet<String> uniqueFields = new HashSet<String>();
        int aliasID = 1;
        for (AggregateField aggregateField : aggregateFields) {
            if (uniqueFields.contains(aggregateField.getAlias())) continue;
            uniqueFields.add(aggregateField.getAlias());
            String serverAlias = "aggregate_" + aliasID++;
            aliasMap.put(serverAlias, aggregateField.getAlias());
            StructuredAggregationQuery.Aggregation.Builder aggregation = StructuredAggregationQuery.Aggregation.newBuilder();
            StructuredQuery.FieldReference fieldPath = (StructuredQuery.FieldReference)StructuredQuery.FieldReference.newBuilder().setFieldPath(aggregateField.getFieldPath()).build();
            if (aggregateField instanceof AggregateField.CountAggregateField) {
                aggregation.setCount(StructuredAggregationQuery.Aggregation.Count.getDefaultInstance());
            } else if (aggregateField instanceof AggregateField.SumAggregateField) {
                aggregation.setSum((StructuredAggregationQuery.Aggregation.Sum)StructuredAggregationQuery.Aggregation.Sum.newBuilder().setField(fieldPath).build());
            } else if (aggregateField instanceof AggregateField.AverageAggregateField) {
                aggregation.setAvg((StructuredAggregationQuery.Aggregation.Avg)StructuredAggregationQuery.Aggregation.Avg.newBuilder().setField(fieldPath).build());
            } else {
                throw new RuntimeException("Unsupported aggregation");
            }
            aggregation.setAlias(serverAlias);
            aggregations.add((StructuredAggregationQuery.Aggregation)aggregation.build());
        }
        structuredAggregationQuery.addAllAggregations(aggregations);
        return (StructuredAggregationQuery)structuredAggregationQuery.build();
    }

    private StructuredQuery.Filter encodeFilters(List<Filter> filters) {
        return this.encodeFilter(new CompositeFilter(filters, CompositeFilter.Operator.AND));
    }

    private List<Filter> decodeFilters(StructuredQuery.Filter proto) {
        CompositeFilter compositeFilter;
        Filter result = this.decodeFilter(proto);
        if (result instanceof CompositeFilter && (compositeFilter = (CompositeFilter)result).isFlatConjunction()) {
            return compositeFilter.getFilters();
        }
        return Collections.singletonList(result);
    }

    @VisibleForTesting
    StructuredQuery.Filter encodeFilter(Filter filter) {
        if (filter instanceof FieldFilter) {
            return this.encodeUnaryOrFieldFilter((FieldFilter)filter);
        }
        if (filter instanceof CompositeFilter) {
            return this.encodeCompositeFilter((CompositeFilter)filter);
        }
        throw Assert.fail("Unrecognized filter type %s", filter.toString());
    }

    @VisibleForTesting
    StructuredQuery.Filter encodeUnaryOrFieldFilter(FieldFilter filter) {
        if (filter.getOperator() == FieldFilter.Operator.EQUAL || filter.getOperator() == FieldFilter.Operator.NOT_EQUAL) {
            StructuredQuery.UnaryFilter.Builder unaryProto = StructuredQuery.UnaryFilter.newBuilder();
            unaryProto.setField(this.encodeFieldPath(filter.getField()));
            if (Values.isNanValue(filter.getValue())) {
                unaryProto.setOp(filter.getOperator() == FieldFilter.Operator.EQUAL ? StructuredQuery.UnaryFilter.Operator.IS_NAN : StructuredQuery.UnaryFilter.Operator.IS_NOT_NAN);
                return (StructuredQuery.Filter)StructuredQuery.Filter.newBuilder().setUnaryFilter(unaryProto).build();
            }
            if (Values.isNullValue(filter.getValue())) {
                unaryProto.setOp(filter.getOperator() == FieldFilter.Operator.EQUAL ? StructuredQuery.UnaryFilter.Operator.IS_NULL : StructuredQuery.UnaryFilter.Operator.IS_NOT_NULL);
                return (StructuredQuery.Filter)StructuredQuery.Filter.newBuilder().setUnaryFilter(unaryProto).build();
            }
        }
        StructuredQuery.FieldFilter.Builder proto = StructuredQuery.FieldFilter.newBuilder();
        proto.setField(this.encodeFieldPath(filter.getField()));
        proto.setOp(this.encodeFieldFilterOperator(filter.getOperator()));
        proto.setValue(filter.getValue());
        return (StructuredQuery.Filter)StructuredQuery.Filter.newBuilder().setFieldFilter(proto).build();
    }

    StructuredQuery.CompositeFilter.Operator encodeCompositeFilterOperator(CompositeFilter.Operator op) {
        switch (op) {
            case AND: {
                return StructuredQuery.CompositeFilter.Operator.AND;
            }
            case OR: {
                return StructuredQuery.CompositeFilter.Operator.OR;
            }
        }
        throw Assert.fail("Unrecognized composite filter type.", new Object[0]);
    }

    CompositeFilter.Operator decodeCompositeFilterOperator(StructuredQuery.CompositeFilter.Operator op) {
        switch (op) {
            case AND: {
                return CompositeFilter.Operator.AND;
            }
            case OR: {
                return CompositeFilter.Operator.OR;
            }
        }
        throw Assert.fail("Only AND and OR composite filter types are supported.", new Object[0]);
    }

    @VisibleForTesting
    StructuredQuery.Filter encodeCompositeFilter(CompositeFilter compositeFilter) {
        ArrayList<StructuredQuery.Filter> protos = new ArrayList<StructuredQuery.Filter>(compositeFilter.getFilters().size());
        for (Filter filter : compositeFilter.getFilters()) {
            protos.add(this.encodeFilter(filter));
        }
        if (protos.size() == 1) {
            return (StructuredQuery.Filter)protos.get(0);
        }
        StructuredQuery.CompositeFilter.Builder composite = StructuredQuery.CompositeFilter.newBuilder();
        composite.setOp(this.encodeCompositeFilterOperator(compositeFilter.getOperator()));
        composite.addAllFilters(protos);
        return (StructuredQuery.Filter)StructuredQuery.Filter.newBuilder().setCompositeFilter(composite).build();
    }

    @VisibleForTesting
    Filter decodeFilter(StructuredQuery.Filter proto) {
        switch (proto.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                return this.decodeCompositeFilter(proto.getCompositeFilter());
            }
            case FIELD_FILTER: {
                return this.decodeFieldFilter(proto.getFieldFilter());
            }
            case UNARY_FILTER: {
                return this.decodeUnaryFilter(proto.getUnaryFilter());
            }
        }
        throw Assert.fail("Unrecognized Filter.filterType %d", new Object[]{proto.getFilterTypeCase()});
    }

    @VisibleForTesting
    FieldFilter decodeFieldFilter(StructuredQuery.FieldFilter proto) {
        FieldPath fieldPath = FieldPath.fromServerFormat(proto.getField().getFieldPath());
        FieldFilter.Operator filterOperator = this.decodeFieldFilterOperator(proto.getOp());
        return FieldFilter.create(fieldPath, filterOperator, proto.getValue());
    }

    private Filter decodeUnaryFilter(StructuredQuery.UnaryFilter proto) {
        FieldPath fieldPath = FieldPath.fromServerFormat(proto.getField().getFieldPath());
        switch (proto.getOp()) {
            case IS_NAN: {
                return FieldFilter.create(fieldPath, FieldFilter.Operator.EQUAL, Values.NAN_VALUE);
            }
            case IS_NULL: {
                return FieldFilter.create(fieldPath, FieldFilter.Operator.EQUAL, Values.NULL_VALUE);
            }
            case IS_NOT_NAN: {
                return FieldFilter.create(fieldPath, FieldFilter.Operator.NOT_EQUAL, Values.NAN_VALUE);
            }
            case IS_NOT_NULL: {
                return FieldFilter.create(fieldPath, FieldFilter.Operator.NOT_EQUAL, Values.NULL_VALUE);
            }
        }
        throw Assert.fail("Unrecognized UnaryFilter.operator %d", new Object[]{proto.getOp()});
    }

    @VisibleForTesting
    CompositeFilter decodeCompositeFilter(StructuredQuery.CompositeFilter compositeFilter) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (StructuredQuery.Filter filter : compositeFilter.getFiltersList()) {
            filters.add(this.decodeFilter(filter));
        }
        return new CompositeFilter(filters, this.decodeCompositeFilterOperator(compositeFilter.getOp()));
    }

    private StructuredQuery.FieldReference encodeFieldPath(FieldPath field) {
        return (StructuredQuery.FieldReference)StructuredQuery.FieldReference.newBuilder().setFieldPath(field.canonicalString()).build();
    }

    private StructuredQuery.FieldFilter.Operator encodeFieldFilterOperator(FieldFilter.Operator operator) {
        switch (operator) {
            case LESS_THAN: {
                return StructuredQuery.FieldFilter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case EQUAL: {
                return StructuredQuery.FieldFilter.Operator.EQUAL;
            }
            case NOT_EQUAL: {
                return StructuredQuery.FieldFilter.Operator.NOT_EQUAL;
            }
            case GREATER_THAN: {
                return StructuredQuery.FieldFilter.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case ARRAY_CONTAINS: {
                return StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS;
            }
            case IN: {
                return StructuredQuery.FieldFilter.Operator.IN;
            }
            case ARRAY_CONTAINS_ANY: {
                return StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY;
            }
            case NOT_IN: {
                return StructuredQuery.FieldFilter.Operator.NOT_IN;
            }
        }
        throw Assert.fail("Unknown operator %d", new Object[]{operator});
    }

    private FieldFilter.Operator decodeFieldFilterOperator(StructuredQuery.FieldFilter.Operator operator) {
        switch (operator) {
            case LESS_THAN: {
                return FieldFilter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return FieldFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case EQUAL: {
                return FieldFilter.Operator.EQUAL;
            }
            case NOT_EQUAL: {
                return FieldFilter.Operator.NOT_EQUAL;
            }
            case GREATER_THAN_OR_EQUAL: {
                return FieldFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return FieldFilter.Operator.GREATER_THAN;
            }
            case ARRAY_CONTAINS: {
                return FieldFilter.Operator.ARRAY_CONTAINS;
            }
            case IN: {
                return FieldFilter.Operator.IN;
            }
            case ARRAY_CONTAINS_ANY: {
                return FieldFilter.Operator.ARRAY_CONTAINS_ANY;
            }
            case NOT_IN: {
                return FieldFilter.Operator.NOT_IN;
            }
        }
        throw Assert.fail("Unhandled FieldFilter.operator %d", new Object[]{operator});
    }

    private StructuredQuery.Order encodeOrderBy(OrderBy orderBy) {
        StructuredQuery.Order.Builder proto = StructuredQuery.Order.newBuilder();
        if (orderBy.getDirection().equals((Object)OrderBy.Direction.ASCENDING)) {
            proto.setDirection(StructuredQuery.Direction.ASCENDING);
        } else {
            proto.setDirection(StructuredQuery.Direction.DESCENDING);
        }
        proto.setField(this.encodeFieldPath(orderBy.getField()));
        return (StructuredQuery.Order)proto.build();
    }

    private OrderBy decodeOrderBy(StructuredQuery.Order proto) {
        OrderBy.Direction direction;
        FieldPath fieldPath = FieldPath.fromServerFormat(proto.getField().getFieldPath());
        switch (proto.getDirection()) {
            case ASCENDING: {
                direction = OrderBy.Direction.ASCENDING;
                break;
            }
            case DESCENDING: {
                direction = OrderBy.Direction.DESCENDING;
                break;
            }
            default: {
                throw Assert.fail("Unrecognized direction %d", new Object[]{proto.getDirection()});
            }
        }
        return OrderBy.getInstance(direction, fieldPath);
    }

    public WatchChange decodeWatchChange(ListenResponse protoChange) {
        WatchChange watchChange;
        switch (protoChange.getResponseTypeCase()) {
            case TARGET_CHANGE: {
                WatchChange.WatchTargetChangeType changeType;
                TargetChange targetChange = protoChange.getTargetChange();
                Status cause = null;
                switch (targetChange.getTargetChangeType()) {
                    case NO_CHANGE: {
                        changeType = WatchChange.WatchTargetChangeType.NoChange;
                        break;
                    }
                    case ADD: {
                        changeType = WatchChange.WatchTargetChangeType.Added;
                        break;
                    }
                    case REMOVE: {
                        changeType = WatchChange.WatchTargetChangeType.Removed;
                        cause = this.fromStatus(targetChange.getCause());
                        break;
                    }
                    case CURRENT: {
                        changeType = WatchChange.WatchTargetChangeType.Current;
                        break;
                    }
                    case RESET: {
                        changeType = WatchChange.WatchTargetChangeType.Reset;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown target change type");
                    }
                }
                watchChange = new WatchChange.WatchTargetChange(changeType, targetChange.getTargetIdsList(), targetChange.getResumeToken(), cause);
                break;
            }
            case DOCUMENT_CHANGE: {
                DocumentChange docChange = protoChange.getDocumentChange();
                List<Integer> added = docChange.getTargetIdsList();
                List<Integer> removed = docChange.getRemovedTargetIdsList();
                DocumentKey key = this.decodeKey(docChange.getDocument().getName());
                SnapshotVersion version = this.decodeVersion(docChange.getDocument().getUpdateTime());
                Assert.hardAssert(!version.equals(SnapshotVersion.NONE), "Got a document change without an update time", new Object[0]);
                ObjectValue data = ObjectValue.fromMap(docChange.getDocument().getFieldsMap());
                MutableDocument document = MutableDocument.newFoundDocument(key, version, data);
                watchChange = new WatchChange.DocumentChange(added, removed, document.getKey(), document);
                break;
            }
            case DOCUMENT_DELETE: {
                DocumentDelete docDelete = protoChange.getDocumentDelete();
                List<Integer> removed = docDelete.getRemovedTargetIdsList();
                DocumentKey key = this.decodeKey(docDelete.getDocument());
                SnapshotVersion version = this.decodeVersion(docDelete.getReadTime());
                MutableDocument doc = MutableDocument.newNoDocument(key, version);
                watchChange = new WatchChange.DocumentChange(Collections.emptyList(), removed, doc.getKey(), doc);
                break;
            }
            case DOCUMENT_REMOVE: {
                DocumentRemove docRemove = protoChange.getDocumentRemove();
                List<Integer> removed = docRemove.getRemovedTargetIdsList();
                DocumentKey key = this.decodeKey(docRemove.getDocument());
                watchChange = new WatchChange.DocumentChange(Collections.emptyList(), removed, key, null);
                break;
            }
            case FILTER: {
                com.google.firestore.v1.ExistenceFilter protoFilter = protoChange.getFilter();
                ExistenceFilter filter = new ExistenceFilter(protoFilter.getCount(), protoFilter.getUnchangedNames());
                int targetId = protoFilter.getTargetId();
                watchChange = new WatchChange.ExistenceFilterWatchChange(targetId, filter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown change type set");
            }
        }
        return watchChange;
    }

    public SnapshotVersion decodeVersionFromListenResponse(ListenResponse watchChange) {
        if (watchChange.getResponseTypeCase() != ListenResponse.ResponseTypeCase.TARGET_CHANGE) {
            return SnapshotVersion.NONE;
        }
        if (watchChange.getTargetChange().getTargetIdsCount() != 0) {
            return SnapshotVersion.NONE;
        }
        return this.decodeVersion(watchChange.getTargetChange().getReadTime());
    }

    private Status fromStatus(com.google.rpc.Status status) {
        return Status.fromCodeValue((int)status.getCode()).withDescription(status.getMessage());
    }
}

