/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.content.Context;
import androidx.annotation.GuardedBy;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.FirebaseFunctions;
import java.util.HashMap;
import java.util.Map;

class FunctionsMultiResourceComponent {
    @GuardedBy(value="this")
    private final Map<String, FirebaseFunctions> instances = new HashMap<String, FirebaseFunctions>();
    private final Context applicationContext;
    private final ContextProvider contextProvider;
    private final String projectId;

    FunctionsMultiResourceComponent(Context applicationContext, ContextProvider contextProvider, String projectId) {
        this.applicationContext = applicationContext;
        this.contextProvider = contextProvider;
        this.projectId = projectId;
    }

    synchronized FirebaseFunctions get(String region) {
        FirebaseFunctions functions = this.instances.get(region);
        if (functions == null) {
            functions = new FirebaseFunctions(this.applicationContext, this.projectId, region, this.contextProvider);
            this.instances.put(region, functions);
        }
        return functions;
    }
}

