/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.content.Context;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.appcheck.interop.InternalAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.FirebaseContextProvider;
import com.google.firebase.functions.FunctionsMultiResourceComponent;
import com.google.firebase.functions.dagger.Binds;
import com.google.firebase.functions.dagger.BindsInstance;
import com.google.firebase.functions.dagger.Component;
import com.google.firebase.functions.dagger.Module;
import com.google.firebase.functions.dagger.Provides;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;
import java.util.concurrent.Executor;
import javax.inject.Named;
import javax.inject.Singleton;

@Component(modules={MainModule.class})
@Singleton
interface FunctionsComponent {
    public FunctionsMultiResourceComponent getMultiResourceComponent();

    @Module
    public static interface MainModule {
        @Provides
        @Named(value="projectId")
        public static String bindProjectId(FirebaseOptions options) {
            return options.getProjectId();
        }

        @Binds
        public ContextProvider contextProvider(FirebaseContextProvider var1);
    }

    @Component.Builder
    public static interface Builder {
        @BindsInstance
        public Builder setApplicationContext(Context var1);

        @BindsInstance
        public Builder setFirebaseOptions(FirebaseOptions var1);

        @BindsInstance
        public Builder setLiteExecutor(@Lightweight Executor var1);

        @BindsInstance
        public Builder setUiExecutor(@UiThread Executor var1);

        @BindsInstance
        public Builder setAuth(Provider<InternalAuthProvider> var1);

        @BindsInstance
        public Builder setIid(Provider<FirebaseInstanceIdInternal> var1);

        @BindsInstance
        public Builder setAppCheck(Deferred<InternalAppCheckTokenProvider> var1);

        public FunctionsComponent build();
    }
}

