/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.iid.MessengerCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzd;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import java.util.Random;

public class zzf {
    static String zzbhW = null;
    static int zzbhX = 0;
    static int zzbhY = 0;
    static int zzbhZ = 0;
    Context zzqn;
    private final SimpleArrayMap<String, zzb> zzclo = new SimpleArrayMap();
    Messenger zzbgJ;
    Messenger zzbib;
    MessengerCompat zzbic;
    PendingIntent zzbgF;
    long zzbid;
    long zzbie;
    int zzbif;
    int zzbig;
    long zzbih;

    public zzf(Context context) {
        this.zzqn = context;
    }

    public static String zzbA(Context context) {
        ApplicationInfo applicationInfo;
        if (zzbhW != null) {
            return zzbhW;
        }
        zzbhX = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string;
            if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", resolveInfo.serviceInfo.packageName)) {
                try {
                    string = packageManager.getApplicationInfo(resolveInfo.serviceInfo.packageName, 0);
                    int n = ((ApplicationInfo)string).uid;
                    Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(17).append("Found ").append(n).toString());
                    zzbhY = ((ApplicationInfo)string).uid;
                    zzbhW = resolveInfo.serviceInfo.packageName;
                    return zzbhW;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    continue;
                }
            }
            string = String.valueOf(resolveInfo.serviceInfo.packageName);
            String string2 = String.valueOf("com.google.android.c2dm.intent.REGISTER");
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve REGISTER intent, falling back");
        try {
            applicationInfo = packageManager.getApplicationInfo("com.google.android.gms", 0);
            zzbhW = applicationInfo.packageName;
            zzbhY = applicationInfo.uid;
            return zzbhW;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                applicationInfo = packageManager.getApplicationInfo("com.google.android.gsf", 0);
                zzbhW = applicationInfo.packageName;
                zzbhY = applicationInfo.uid;
                return zzbhW;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                Log.w((String)"InstanceID/Rpc", (String)"Both Google Play Services and legacy GSF package are missing");
                return null;
            }
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return FirebaseInstanceId.zzv(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzHl() {
        if (this.zzbgJ != null) {
            return;
        }
        zzf.zzbA(this.zzqn);
        this.zzbgJ = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                zzf.this.zze(message);
            }
        });
    }

    public void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzbic = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzbib = (Messenger)parcelable;
                }
            }
            this.zzv((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    synchronized void zzs(Intent intent) {
        if (this.zzbgF == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzbgF = PendingIntent.getBroadcast((Context)this.zzqn, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzbgF);
    }

    public void zza(Bundle bundle, KeyPair keyPair, String string) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzbih != 0L && l <= this.zzbih) {
            long l2 = this.zzbih - l;
            int n = this.zzbig;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
            throw new IOException("RETRY_LATER");
        }
        this.zzHl();
        if (zzbhW == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.zzbid = SystemClock.elapsedRealtime();
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzbhW);
        bundle.putString("gmsv", Integer.toString(FirebaseInstanceId.zzQ(this.zzqn, zzf.zzbA(this.zzqn))));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(FirebaseInstanceId.zzcs(this.zzqn)));
        bundle.putString("app_ver_name", FirebaseInstanceId.zzby(this.zzqn));
        bundle.putString("cliv", "fiid-10298000");
        bundle.putString("appid", FirebaseInstanceId.zza(keyPair));
        String string2 = FirebaseInstanceId.zzcr(this.zzqn);
        if (string2 != null) {
            bundle.putString("gmp_app_id", string2);
        }
        String string3 = FirebaseInstanceId.zzv(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string3);
        bundle.putString("sig", zzf.zza(keyPair, this.zzqn.getPackageName(), string3));
        intent.putExtras(bundle);
        this.zzs(intent);
        this.zzb(intent, string);
    }

    protected void zzb(Intent intent, String string) {
        block7: {
            String string2;
            this.zzbid = SystemClock.elapsedRealtime();
            intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            boolean bl = "com.google.android.gsf".equals(zzbhW);
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                string2 = String.valueOf(intent.getExtras());
                Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
            }
            if (bl) {
                this.zzqn.startService(intent);
                return;
            }
            intent.putExtra("google.messenger", (Parcelable)this.zzbgJ);
            if (this.zzbib != null || this.zzbic != null) {
                string2 = Message.obtain();
                ((Message)string2).obj = intent;
                try {
                    if (this.zzbib != null) {
                        this.zzbib.send((Message)string2);
                    } else {
                        this.zzbic.send((Message)string2);
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block7;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        this.zzqn.startService(intent);
    }

    String zzt(Intent intent) throws IOException {
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    void zzu(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        String string4 = null;
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            if (stringArray.length > 2) {
                string4 = stringArray[2];
                string = stringArray[3];
                if (string.startsWith(":")) {
                    string = string.substring(1);
                }
            } else {
                string = "UNKNOWN";
            }
            intent.putExtra("error", string);
        }
        this.zzay(string4, string);
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.zzbie = SystemClock.elapsedRealtime();
            this.zzbig = (int)l * 1000;
            this.zzbih = SystemClock.elapsedRealtime() + (long)this.zzbig;
            int n = this.zzbig;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
        } else if ("SERVICE_NOT_AVAILABLE".equals(string) || "AUTHENTICATION_FAILED".equals(string)) {
            this.zzeF(string);
        }
    }

    private void zzeF(String string) {
        if (!"com.google.android.gsf".equals(zzbhW)) {
            return;
        }
        ++this.zzbif;
        if (this.zzbif < 3) {
            return;
        }
        if (this.zzbif == 3) {
            this.zzbig = 1000 + new Random().nextInt(1000);
        }
        this.zzbig *= 2;
        this.zzbih = SystemClock.elapsedRealtime() + (long)this.zzbig;
        int n = this.zzbig;
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Backoff due to ").append(string).append(" for ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(String string, Intent intent) {
        SimpleArrayMap<String, zzb> simpleArrayMap = this.zzclo;
        synchronized (simpleArrayMap) {
            zzb zzb2 = (zzb)this.zzclo.remove((Object)string);
            if (zzb2 == null) {
                String string2 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for ")));
                return;
            }
            zzb2.zzK(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzay(String string, String string2) {
        SimpleArrayMap<String, zzb> simpleArrayMap = this.zzclo;
        synchronized (simpleArrayMap) {
            if (string == null) {
                for (int i = 0; i < this.zzclo.size(); ++i) {
                    ((zzb)this.zzclo.valueAt(i)).onError(string2);
                }
                this.zzclo.clear();
            } else {
                zzb zzb2 = (zzb)this.zzclo.remove((Object)string);
                if (zzb2 == null) {
                    String string3 = String.valueOf(string);
                    Log.w((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Missing callback for ".concat(string3) : new String("Missing callback for ")));
                    return;
                }
                zzb2.onError(string2);
            }
        }
    }

    void zzv(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            this.zzu(intent);
            return;
        }
        this.zzbid = SystemClock.elapsedRealtime();
        this.zzbih = 0L;
        this.zzbif = 0;
        this.zzbig = 0;
        String string4 = null;
        if (string3.startsWith("|")) {
            String[] stringArray = string3.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string3);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            string4 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    FirebaseInstanceId.zzbz(this.zzqn);
                } else if ("RST".equals(stringArray[3])) {
                    FirebaseInstanceId.zza(this.zzqn, zzd.zzb(this.zzqn, null).zzabP());
                    intent.removeExtra("registration_id");
                    this.zzb(string4, intent);
                    return;
                }
            }
            if ((string3 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string3 = string3.substring(1);
            }
            intent.putExtra("registration_id", string3);
        }
        if (string4 == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Ignoring response without a request ID");
            }
            return;
        }
        this.zzb(string4, intent);
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger") && (intent = this.zzb(bundle, keyPair)) != null && intent.hasExtra("google.messenger")) {
            intent = null;
        }
        return intent;
    }

    public static synchronized String zzHm() {
        return Integer.toString(zzbhZ++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        String string = zzf.zzHm();
        zza zza2 = new zza();
        Intent intent = this.zzclo;
        synchronized (intent) {
            this.zzclo.put((Object)string, (Object)zza2);
        }
        this.zza(bundle, keyPair, string);
        try {
            intent = zza2.zzabS();
            return intent;
        }
        finally {
            SimpleArrayMap<String, zzb> simpleArrayMap = this.zzclo;
            synchronized (simpleArrayMap) {
                this.zzclo.remove((Object)string);
            }
        }
    }

    private static class zza
    implements zzb {
        private final ConditionVariable zzclq = new ConditionVariable();
        private Intent intent;
        private String zzclr;

        private zza() {
        }

        @Override
        public void zzK(Intent intent) {
            this.intent = intent;
            this.zzclq.open();
        }

        @Override
        public void onError(String string) {
            this.zzclr = string;
            this.zzclq.open();
        }

        public Intent zzabS() throws IOException {
            if (!this.zzclq.block(30000L)) {
                Log.w((String)"InstanceID/Rpc", (String)"No response");
                throw new IOException("TIMEOUT");
            }
            if (this.zzclr != null) {
                throw new IOException(this.zzclr);
            }
            return this.intent;
        }
    }

    private static interface zzb {
        public void zzK(Intent var1);

        public void onError(String var1);
    }
}

