/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zze;
import com.google.firebase.iid.zzf;
import com.google.firebase.iid.zzg;
import com.google.firebase.iid.zzh;
import java.io.IOException;

public class FirebaseInstanceIdService
extends zzb {
    @VisibleForTesting
    static final Object zzclr = new Object();
    @VisibleForTesting
    static boolean zzcls = false;
    private boolean zzclt = false;

    public boolean zzE(Intent intent) {
        this.zzclt = Log.isLoggable((String)"FirebaseInstanceId", (int)3);
        if (intent.getStringExtra("error") != null || intent.getStringExtra("registration_id") != null) {
            String string = this.zzG(intent);
            if (this.zzclt) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            this.zzjw(string).zzabT().zzs(intent);
            return true;
        }
        return false;
    }

    public void handleIntent(Intent intent) {
        String string = intent.getAction();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "ACTION_TOKEN_REFRESH_RETRY": {
                this.zza(intent, false, false);
                return;
            }
        }
        this.zzF(intent);
    }

    protected Intent zzD(Intent intent) {
        return zzg.zzabW().zzabX();
    }

    public void zzF(Intent intent) {
        String string = this.zzG(intent);
        zzd zzd2 = this.zzjw(string);
        String string2 = intent.getStringExtra("CMD");
        if (this.zzclt) {
            String string3 = String.valueOf(intent.getExtras());
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Service command ").append(string).append(" ").append(string2).append(" ").append(string3).toString());
        }
        if (null != intent.getStringExtra("unregistered")) {
            zzd2.zzabS().zzeK(string == null ? "" : string);
            zzd2.zzabT().zzs(intent);
            return;
        }
        if ("gcm.googleapis.com/refresh".equals(intent.getStringExtra("from"))) {
            zzd2.zzabS().zzeK(string);
            this.zza(intent, false, true);
            return;
        }
        if ("RST".equals(string2)) {
            zzd2.zzHi();
            this.zza(intent, true, true);
        } else if ("RST_FULL".equals(string2)) {
            if (!zzd2.zzabS().isEmpty()) {
                zzd2.zzHi();
                zzd2.zzabS().zzHo();
                this.zza(intent, true, true);
            }
        } else if ("SYNC".equals(string2)) {
            zzd2.zzabS().zzeK(string);
            this.zza(intent, false, true);
        } else if ("PING".equals(string2)) {
            this.zzU(intent.getExtras());
        }
    }

    private String zzG(Intent intent) {
        String string = intent.getStringExtra("subtype");
        return string == null ? "" : string;
    }

    private zzd zzjw(String string) {
        if (string == null) {
            return zzd.zzb((Context)this, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("subtype", string);
        return zzd.zzb((Context)this, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(Intent intent, boolean bl, boolean bl2) {
        Object object = zzclr;
        synchronized (object) {
            zzcls = false;
        }
        if (zzf.zzbA((Context)this) == null) {
            return;
        }
        object = FirebaseInstanceId.getInstance();
        zzh.zza zza2 = ((FirebaseInstanceId)object).zzabP();
        if (zza2 == null || zza2.zzjB(zzd.zzbhN)) {
            try {
                String string = ((FirebaseInstanceId)object).zzabQ();
                if (string != null) {
                    if (this.zzclt) {
                        Log.d((String)"FirebaseInstanceId", (String)"get master token succeeded");
                    }
                    FirebaseInstanceIdService.zza((Context)this, (FirebaseInstanceId)object);
                    if (bl2 || zza2 == null || zza2 != null && !string.equals(zza2.zzbxW)) {
                        this.onTokenRefresh();
                    }
                    return;
                }
                this.zzd(intent, "returned token is null");
            }
            catch (IOException iOException) {
                this.zzd(intent, iOException.getMessage());
            }
            catch (SecurityException securityException) {
                Log.e((String)"FirebaseInstanceId", (String)"Unable to get master token", (Throwable)securityException);
                return;
            }
            return;
        }
        zze zze2 = ((FirebaseInstanceId)object).zzabR();
        String string = zze2.zzabU();
        while (string != null) {
            String[] stringArray = string.split("!");
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                try {
                    switch (string2) {
                        case "S": {
                            FirebaseInstanceId.getInstance().zzju(string3);
                            if (!this.zzclt) break;
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                            break;
                        }
                        case "U": {
                            FirebaseInstanceId.getInstance().zzjv(string3);
                            if (!this.zzclt) break;
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        }
                    }
                }
                catch (IOException iOException) {
                    this.zzd(intent, iOException.getMessage());
                    return;
                }
            }
            zze2.zzjx(string);
            string = zze2.zzabU();
        }
        Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzd(Intent intent, String string) {
        boolean bl = FirebaseInstanceIdService.zzcu((Context)this);
        int n = this.zza(intent, bl);
        Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(47 + String.valueOf(string).length()).append("background sync failed: ").append(string).append(", retry in ").append(n).append("s").toString());
        Object object = zzclr;
        synchronized (object) {
            this.zzqG(n);
            zzcls = true;
        }
        if (!bl) {
            if (this.zzclt) {
                Log.d((String)"FirebaseInstanceId", (String)"device not connected. Connectivity change received registered");
            }
            zza.zzl((Context)this, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Context context, FirebaseInstanceId firebaseInstanceId) {
        Object object = zzclr;
        synchronized (object) {
            if (zzcls) {
                return;
            }
        }
        object = firebaseInstanceId.zzabP();
        if (object == null || ((zzh.zza)object).zzjB(zzd.zzbhN) || firebaseInstanceId.zzabR().zzabU() != null) {
            FirebaseInstanceIdService.zzct(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzct(Context context) {
        if (zzf.zzbA(context) == null) {
            return;
        }
        Object object = zzclr;
        synchronized (object) {
            if (!zzcls) {
                zzg.zzabW().zzg(context, FirebaseInstanceIdService.zzqF(0));
                zzcls = true;
            }
        }
    }

    private static Intent zzqF(int n) {
        Intent intent = new Intent("ACTION_TOKEN_REFRESH_RETRY");
        intent.putExtra("next_retry_delay_in_seconds", n);
        return intent;
    }

    private void zzqG(int n) {
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        PendingIntent pendingIntent = zzg.zza((Context)this, 0, FirebaseInstanceIdService.zzqF(n * 2), 0x8000000);
        alarmManager.set(3, SystemClock.elapsedRealtime() + (long)(n * 1000), pendingIntent);
    }

    private int zza(Intent intent, boolean bl) {
        int n = intent == null ? 10 : intent.getIntExtra("next_retry_delay_in_seconds", 0);
        if (n < 10 && !bl) {
            n = 30;
        } else if (n < 10) {
            n = 10;
        } else if (n > 28800) {
            n = 28800;
        }
        return n;
    }

    private static boolean zzcu(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private void zzU(Bundle bundle) {
        String string = zzf.zzbA((Context)this);
        if (string == null) {
            Log.w((String)"FirebaseInstanceId", (String)"Unable to respond to ping due to missing target package");
            return;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        intent.setPackage(string);
        intent.putExtras(bundle);
        zzf.zzf((Context)this, intent);
        intent.putExtra("google.to", "google.com/iid");
        intent.putExtra("google.message_id", zzf.zzHn());
        this.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @WorkerThread
    public void onTokenRefresh() {
    }

    private static class zza
    extends BroadcastReceiver {
        @Nullable
        static BroadcastReceiver receiver;
        final int zzclu;

        static synchronized void zzl(Context context, int n) {
            if (receiver != null) {
                return;
            }
            receiver = new zza(n);
            context.getApplicationContext().registerReceiver(receiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }

        zza(int n) {
            this.zzclu = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Class<zza> clazz = zza.class;
            synchronized (zza.class) {
                if (receiver != this) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                if (!FirebaseInstanceIdService.zzcu(context)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    Log.d((String)"FirebaseInstanceId", (String)"connectivity changed. starting background sync.");
                }
                context.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
                receiver = null;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                zzg.zzabW().zzg(context, FirebaseInstanceIdService.zzqF(this.zzclu));
                return;
            }
        }
    }
}

