/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceIdInternalReceiver;
import java.util.LinkedList;
import java.util.Queue;

public class zzg {
    private static zzg zzclC;
    private final SimpleArrayMap<String, String> zzclD = new SimpleArrayMap();
    private Boolean zzclE = null;
    @VisibleForTesting
    final Queue<Intent> zzclF = new LinkedList<Intent>();
    @VisibleForTesting
    final Queue<Intent> zzclG = new LinkedList<Intent>();

    public static synchronized zzg zzabW() {
        if (zzclC == null) {
            zzclC = new zzg();
        }
        return zzclC;
    }

    private zzg() {
    }

    public static PendingIntent zza(Context context, int n, Intent intent, int n2) {
        return zzg.zza(context, n, "com.google.firebase.INSTANCE_ID_EVENT", intent, n2);
    }

    public static PendingIntent zzb(Context context, int n, Intent intent, int n2) {
        return zzg.zza(context, n, "com.google.firebase.MESSAGING_EVENT", intent, n2);
    }

    private static PendingIntent zza(Context context, int n, String string, Intent intent, int n2) {
        Intent intent2 = new Intent(context, FirebaseInstanceIdInternalReceiver.class);
        intent2.setAction(string);
        intent2.putExtra("wrapped_intent", (Parcelable)intent);
        return PendingIntent.getBroadcast((Context)context, (int)n, (Intent)intent2, (int)n2);
    }

    public Intent zzabX() {
        return this.zzclF.poll();
    }

    public Intent zzabY() {
        return this.zzclG.poll();
    }

    public void zzg(Context context, Intent intent) {
        this.zzb(context, "com.google.firebase.INSTANCE_ID_EVENT", intent);
    }

    public int zzb(Context context, String string, Intent intent) {
        switch (string) {
            case "com.google.firebase.INSTANCE_ID_EVENT": {
                this.zzclF.offer(intent);
                break;
            }
            case "com.google.firebase.MESSAGING_EVENT": {
                this.zzclG.offer(intent);
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Unknown service action: ".concat(string2) : new String("Unknown service action: ")));
                return 500;
            }
        }
        String string3 = new Intent(string);
        string3.setPackage(context.getPackageName());
        return this.zzh(context, (Intent)string3);
    }

    private int zzh(Context context, Intent intent) {
        this.zze(context, intent);
        try {
            ComponentName componentName;
            if (this.zzcw(context)) {
                componentName = WakefulBroadcastReceiver.startWakefulService((Context)context, (Intent)intent);
            } else {
                componentName = context.startService(intent);
                Log.d((String)"FirebaseInstanceId", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (componentName == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException securityException) {
            Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
            return 401;
        }
        catch (IllegalStateException illegalStateException) {
            String string = String.valueOf(illegalStateException);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Failed to start service while in background: ").append(string).toString());
            return 402;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zze(Context context, Intent intent) {
        String string;
        ResolveInfo resolveInfo = this.zzclD;
        synchronized (resolveInfo) {
            string = (String)this.zzclD.get((Object)intent.getAction());
        }
        if (string == null) {
            String string2;
            resolveInfo = context.getPackageManager().resolveService(intent, 0);
            if (resolveInfo == null || resolveInfo.serviceInfo == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Failed to resolve target intent service, skipping classname enforcement");
                return;
            }
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (!context.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
                String string3 = String.valueOf(serviceInfo.packageName);
                String string4 = String.valueOf(serviceInfo.name);
                Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(94 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(string3).append("/").append(string4).toString());
                return;
            }
            string = serviceInfo.name;
            if (string.startsWith(".")) {
                String string5 = String.valueOf(context.getPackageName());
                String string6 = String.valueOf(string);
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            } else {
                string2 = string;
            }
            string = string2;
            SimpleArrayMap<String, String> simpleArrayMap = this.zzclD;
            synchronized (simpleArrayMap) {
                this.zzclD.put((Object)intent.getAction(), (Object)string);
            }
        }
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string7 = String.valueOf(string);
            Log.d((String)"FirebaseInstanceId", (String)(string7.length() != 0 ? "Restricting intent to a specific service: ".concat(string7) : new String("Restricting intent to a specific service: ")));
        }
        intent.setClassName(context.getPackageName(), string);
    }

    private boolean zzcw(Context context) {
        if (this.zzclE == null) {
            this.zzclE = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
        }
        return this.zzclE;
    }
}

