/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzj;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzs;
import java.io.IOException;

public class FirebaseInstanceIdService
extends zzb {
    @VisibleForTesting
    private static Object zznfp = new Object();
    @VisibleForTesting
    private static boolean zznfq = false;
    private boolean zznfr = false;

    public FirebaseInstanceIdService() {
    }

    public final boolean zzo(Intent intent) {
        this.zznfr = Log.isLoggable((String)"FirebaseInstanceId", (int)3);
        if (intent.getStringExtra("error") != null || intent.getStringExtra("registration_id") != null) {
            String string = FirebaseInstanceIdService.zzp(intent);
            if (this.zznfr) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            this.zzqz(string);
            zzj.zzcgb().zzi(intent);
            return true;
        }
        return false;
    }

    public void handleIntent(Intent intent) {
        String string = intent.getAction();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "ACTION_TOKEN_REFRESH_RETRY": {
                this.zza(intent, false, false);
                return;
            }
        }
        Intent intent2 = intent;
        FirebaseInstanceIdService firebaseInstanceIdService = this;
        String string2 = FirebaseInstanceIdService.zzp(intent2);
        zzj zzj2 = firebaseInstanceIdService.zzqz(string2);
        String string3 = intent2.getStringExtra("CMD");
        if (firebaseInstanceIdService.zznfr) {
            String string4 = String.valueOf(intent2.getExtras());
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(18 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Service command ").append(string2).append(" ").append(string3).append(" ").append(string4).toString());
        }
        if (null != intent2.getStringExtra("unregistered")) {
            zzj.zzcga().zzhu(string2 == null ? "" : string2);
            zzj.zzcgb().zzi(intent2);
            return;
        }
        if ("gcm.googleapis.com/refresh".equals(intent2.getStringExtra("from"))) {
            zzj.zzcga().zzhu(string2);
            firebaseInstanceIdService.zza(intent2, false, true);
            return;
        }
        if ("RST".equals(string3)) {
            zzj2.zzasr();
            firebaseInstanceIdService.zza(intent2, true, true);
            return;
        }
        if ("RST_FULL".equals(string3)) {
            if (!zzj.zzcga().isEmpty()) {
                zzj2.zzasr();
                zzj.zzcga().zzasv();
                firebaseInstanceIdService.zza(intent2, true, true);
                return;
            }
        } else {
            if ("SYNC".equals(string3)) {
                zzj.zzcga().zzhu(string2);
                firebaseInstanceIdService.zza(intent2, false, true);
                return;
            }
            if ("PING".equals(string3)) {
                Bundle bundle = intent2.getExtras();
                FirebaseInstanceIdService firebaseInstanceIdService2 = firebaseInstanceIdService;
                String string5 = zzl.zzdf((Context)firebaseInstanceIdService2);
                if (string5 == null) {
                    Log.w((String)"FirebaseInstanceId", (String)"Unable to respond to ping due to missing target package");
                    return;
                }
                Intent intent3 = new Intent("com.google.android.gcm.intent.SEND");
                intent3.setPackage(string5);
                intent3.putExtras(bundle);
                zzl.zzd((Context)firebaseInstanceIdService2, intent3);
                intent3.putExtra("google.to", "google.com/iid");
                intent3.putExtra("google.message_id", zzl.zzasu());
                firebaseInstanceIdService2.sendOrderedBroadcast(intent3, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
            }
        }
    }

    protected final Intent zzn(Intent intent) {
        return zzq.zzcge().zzngd.poll();
    }

    private static String zzp(Intent intent) {
        String string = intent.getStringExtra("subtype");
        if (string == null) {
            return "";
        }
        return string;
    }

    private final zzj zzqz(String string) {
        if (string == null) {
            return zzj.zza((Context)this, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("subtype", string);
        return zzj.zza((Context)this, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Intent intent, boolean bl, boolean bl2) {
        Object object = zznfp;
        synchronized (object) {
            zznfq = false;
        }
        if (zzl.zzdf((Context)this) == null) {
            return;
        }
        object = FirebaseInstanceId.getInstance();
        zzs zzs2 = ((FirebaseInstanceId)object).zzcfx();
        if (zzs2 == null || zzs2.zzrg(zzj.zzhtt)) {
            try {
                String string = ((FirebaseInstanceId)object).zzcfy();
                if (string != null) {
                    if (this.zznfr) {
                        Log.d((String)"FirebaseInstanceId", (String)"get master token succeeded");
                    }
                    FirebaseInstanceIdService.zza((Context)this, (FirebaseInstanceId)object);
                    if (bl2 || zzs2 == null || zzs2 != null && !string.equals(zzs2.zzkoo)) {
                        this.onTokenRefresh();
                    }
                    return;
                }
                this.zza(intent, "returned token is null");
                return;
            }
            catch (IOException iOException) {
                this.zza(intent, iOException.getMessage());
                return;
            }
            catch (SecurityException securityException) {
                Log.e((String)"FirebaseInstanceId", (String)"Unable to get master token", (Throwable)securityException);
                return;
            }
        }
        zzk zzk2 = FirebaseInstanceId.zzcfz();
        String string = zzk2.zzcgc();
        while (string != null) {
            block24: {
                String[] stringArray = string.split("!");
                if (stringArray.length != 2) break block24;
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                try {
                    switch (string2) {
                        case "S": {
                            FirebaseInstanceId.getInstance().zzqx(string3);
                            if (this.zznfr) {
                                Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                            }
                            break;
                        }
                        case "U": {
                            FirebaseInstanceId.getInstance().zzqy(string3);
                            if (this.zznfr) {
                                Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                            } else {
                                break;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    this.zza(intent, iOException.getMessage());
                    return;
                }
            }
            zzk2.zzra(string);
            string = zzk2.zzcgc();
        }
        Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Intent intent, String string) {
        int n;
        int n2 = n = FirebaseInstanceIdService.zzen((Context)this);
        Object object = intent;
        int n3 = object == null ? 10 : object.getIntExtra("next_retry_delay_in_seconds", 0);
        if (n3 < 10 && n2 == 0) {
            n3 = 30;
        } else if (n3 < 10) {
            n3 = 10;
        } else if (n3 > 28800) {
            n3 = 28800;
        }
        int n4 = n3;
        Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(47 + String.valueOf(string).length()).append("background sync failed: ").append(string).append(", retry in ").append(n4).append("s").toString());
        Object object2 = zznfp;
        synchronized (object2) {
            n2 = n4;
            object = this;
            AlarmManager alarmManager = (AlarmManager)object.getSystemService("alarm");
            PendingIntent pendingIntent = zzq.zza((Context)object, 0, FirebaseInstanceIdService.zzhk(n2 << 1), 0x8000000);
            alarmManager.set(3, SystemClock.elapsedRealtime() + (long)(n2 * 1000), pendingIntent);
            zznfq = true;
        }
        if (n == 0) {
            if (this.zznfr) {
                Log.d((String)"FirebaseInstanceId", (String)"device not connected. Connectivity change received registered");
            }
            zza.zzl((Context)this, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Context context, FirebaseInstanceId firebaseInstanceId) {
        Object object = zznfp;
        synchronized (object) {
            if (zznfq) {
                return;
            }
        }
        object = firebaseInstanceId.zzcfx();
        if (object == null || ((zzs)object).zzrg(zzj.zzhtt) || FirebaseInstanceId.zzcfz().zzcgc() != null) {
            FirebaseInstanceIdService.zzem(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzem(Context context) {
        if (zzl.zzdf(context) == null) {
            return;
        }
        Object object = zznfp;
        synchronized (object) {
            if (!zznfq) {
                zzq.zzcge().zze(context, FirebaseInstanceIdService.zzhk(0));
                zznfq = true;
            }
            return;
        }
    }

    private static Intent zzhk(int n) {
        Intent intent = new Intent("ACTION_TOKEN_REFRESH_RETRY");
        intent.putExtra("next_retry_delay_in_seconds", n);
        return intent;
    }

    private static boolean zzen(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    @WorkerThread
    public void onTokenRefresh() {
    }

    static class zza
    extends BroadcastReceiver {
        @Nullable
        private static BroadcastReceiver receiver;
        private int zznfs;

        static synchronized void zzl(Context context, int n) {
            if (receiver != null) {
                return;
            }
            receiver = new zza(n);
            context.getApplicationContext().registerReceiver(receiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }

        private zza(int n) {
            this.zznfs = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Class<zza> clazz = zza.class;
            synchronized (zza.class) {
                if (receiver != this) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                if (!FirebaseInstanceIdService.zzen(context)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    Log.d((String)"FirebaseInstanceId", (String)"connectivity changed. starting background sync.");
                }
                context.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
                receiver = null;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                zzq.zzcge().zze(context, FirebaseInstanceIdService.zzhk(this.zznfs));
                return;
            }
        }
    }
}

