/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzj;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzm;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzs;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class zzk
implements ServiceConnection {
    int state = 0;
    final Messenger zznzb = new Messenger(new Handler(Looper.getMainLooper(), (Handler.Callback)new zzl(this)));
    zzp zznzc;
    final Queue<zzr<?>> zznzd = new ArrayDeque();
    final SparseArray<zzr<?>> zznze = new SparseArray();
    final /* synthetic */ zzi zznzf;

    private zzk(zzi zzi2) {
        this.zznzf = zzi2;
    }

    final synchronized boolean zzb(zzr zzr2) {
        switch (this.state) {
            case 0: {
                this.zznzd.add(zzr2);
                zzk zzk2 = this;
                zzbq.checkState((zzk2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzk2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!zza.zzamc().zza(zzi.zza(zzk2.zznzf), intent, (ServiceConnection)zzk2, 1)) {
                    zzk2.zzm(0, "Unable to bind to service");
                } else {
                    zzi.zzb(zzk2.zznzf).schedule(new zzm(zzk2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zznzd.add(zzr2);
                return true;
            }
            case 2: {
                this.zznzd.add(zzr2);
                this.zzcjb();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zzd(Message message) {
        zzr zzr2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzk zzk2 = this;
        synchronized (zzk2) {
            zzr2 = (zzr)this.zznze.get(n);
            if (zzr2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zznze.remove(n);
            this.zzcjc();
        }
        Bundle bundle = message.getData();
        zzr zzr3 = zzr2;
        if (bundle.getBoolean("unsupported", false)) {
            zzr3.zzb(new zzs(4, "Not supported by GmsCore"));
        } else {
            zzr3.zzac(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zzm(0, "Null service connection");
            return;
        }
        try {
            this.zznzc = new zzp(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zzm(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzcjb();
    }

    private final void zzcjb() {
        zzi.zzb(this.zznzf).execute(new zzn(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zzm(2, "Service disconnected");
    }

    final synchronized void zzm(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                zza.zzamc();
                zzk zzk2 = this;
                Context context = zzi.zza(this.zznzf);
                context.unbindService((ServiceConnection)zzk2);
                this.zza(new zzs(n, string));
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    private final void zza(zzs zzs2) {
        Iterator iterator = this.zznzd.iterator();
        while (iterator.hasNext()) {
            ((zzr)iterator.next()).zzb(zzs2);
        }
        this.zznzd.clear();
        for (int i = 0; i < this.zznze.size(); ++i) {
            ((zzr)this.zznze.valueAt(i)).zzb(zzs2);
        }
        this.zznze.clear();
    }

    final synchronized void zzcjc() {
        if (this.state == 2 && this.zznzd.isEmpty() && this.zznze.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            zza.zzamc();
            zzk zzk2 = this;
            Context context = zzi.zza(this.zznzf);
            context.unbindService((ServiceConnection)zzk2);
        }
    }

    final synchronized void zzcjd() {
        if (this.state == 1) {
            this.zzm(1, "Timed out while binding");
        }
    }

    final synchronized void zzic(int n) {
        zzr zzr2 = (zzr)this.zznze.get(n);
        if (zzr2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zznze.remove(n);
            zzr2.zzb(new zzs(3, "Timed out waiting for response"));
            this.zzcjc();
        }
    }

    /* synthetic */ zzk(zzi zzi2, zzj zzj2) {
        this(zzi2);
    }
}

