/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzq;
import com.google.firebase.FirebaseApp;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

final class zzu {
    private final Context zzair;
    private String zznzk;
    private String zzct;
    private int zznzl;
    private int zznzm = 0;

    public zzu(Context context) {
        this.zzair = context;
    }

    public final synchronized int zzcjf() {
        List list;
        Intent intent;
        if (this.zznzm != 0) {
            return this.zznzm;
        }
        PackageManager packageManager = this.zzair.getPackageManager();
        if (packageManager.checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
            Log.e((String)"FirebaseInstanceId", (String)"Google Play services missing or without correct permission.");
            return 0;
        }
        if (!zzq.isAtLeastO()) {
            intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                this.zznzm = 1;
                return this.zznzm;
            }
        }
        intent = new Intent("com.google.iid.TOKEN_REQUEST");
        intent.setPackage("com.google.android.gms");
        list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            this.zznzm = 2;
            return this.zznzm;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Failed to resolve IID implementation package, falling back");
        this.zznzm = zzq.isAtLeastO() ? 2 : 1;
        return this.zznzm;
    }

    public static String zzf(FirebaseApp firebaseApp) {
        String string = firebaseApp.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = firebaseApp.getOptions().getApplicationId();
        if (!string2.startsWith("1:")) {
            return string2;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        String string3 = stringArray[1];
        if (string3.isEmpty()) {
            return null;
        }
        return string3;
    }

    public static String zzb(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public final synchronized String zzcjg() {
        if (this.zznzk == null) {
            this.zzcjj();
        }
        return this.zznzk;
    }

    public final synchronized String zzcjh() {
        if (this.zzct == null) {
            this.zzcjj();
        }
        return this.zzct;
    }

    public final synchronized int zzcji() {
        PackageInfo packageInfo;
        if (this.zznzl == 0 && (packageInfo = this.zzoa("com.google.android.gms")) != null) {
            this.zznzl = packageInfo.versionCode;
        }
        return this.zznzl;
    }

    private final synchronized void zzcjj() {
        PackageInfo packageInfo = this.zzoa(this.zzair.getPackageName());
        if (packageInfo != null) {
            this.zznzk = Integer.toString(packageInfo.versionCode);
            this.zzct = packageInfo.versionName;
        }
    }

    private final PackageInfo zzoa(String string) {
        try {
            return this.zzair.getPackageManager().getPackageInfo(string, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return null;
        }
    }
}

