/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzw;
import com.google.firebase.iid.zzx;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FirebaseInstanceId {
    private static final long zza = TimeUnit.HOURS.toSeconds(8L);
    private static Map<String, FirebaseInstanceId> zzb = new ArrayMap();
    private static zzaa zzc;
    private static ScheduledThreadPoolExecutor zzd;
    private final FirebaseApp zze;
    private final zzw zzf;
    private final zzx zzg;
    private KeyPair zzh;
    private boolean zzi = false;
    private boolean zzj;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzb.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            if (zzc == null) {
                zzc = new zzaa(firebaseApp.getApplicationContext());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, new zzw(firebaseApp.getApplicationContext()));
            zzb.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp, zzw zzw2) {
        if (zzw.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        this.zze = firebaseApp;
        this.zzf = zzw2;
        this.zzg = new zzx(firebaseApp.getApplicationContext(), zzw2);
        this.zzj = this.zzl();
        if (this.zzh()) {
            this.zzi();
        }
    }

    private final void zzi() {
        zzab zzab2 = this.zzb();
        if (zzab2 == null || zzab2.zzb(this.zzf.zzb()) || zzc.zza() != null) {
            this.zzj();
        }
    }

    final FirebaseApp zza() {
        return this.zze;
    }

    final synchronized void zza(boolean bl) {
        this.zzi = bl;
    }

    private final synchronized void zzj() {
        if (!this.zzi) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zza);
        FirebaseInstanceId.zza(new zzac(this, this.zzf, l2), l);
        this.zzi = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzd == null) {
                zzd = new ScheduledThreadPoolExecutor(1);
            }
            zzd.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzi();
        return zzw.zza(this.zzk());
    }

    public long getCreationTime() {
        return zzc.zzc("");
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        this.zza("*", "*", bundle);
        this.zzf();
    }

    @Nullable
    public String getToken() {
        zzab zzab2 = this.zzb();
        if (zzab2 == null || zzab2.zzb(this.zzf.zzb())) {
            this.zzj();
        }
        if (zzab2 != null) {
            return zzab2.zza;
        }
        return null;
    }

    @Nullable
    final zzab zzb() {
        return zzc.zza("", zzw.zza(this.zze), "*");
    }

    @Hide
    final String zzc() throws IOException {
        return this.getToken(zzw.zza(this.zze), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        zzab zzab2 = zzc.zza("", string, string2);
        if (zzab2 != null && !zzab2.zzb(this.zzf.zzb())) {
            return zzab2.zza;
        }
        String string3 = this.zza(string, string2, new Bundle());
        if (string3 != null) {
            zzc.zza("", string, string2, string3, this.zzf.zzb());
        }
        return string3;
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        this.zza(string, string2, bundle);
        zzc.zzb("", string, string2);
    }

    @Hide
    public final synchronized void zza(String string) {
        zzc.zza(string);
        this.zzj();
    }

    static zzaa zzd() {
        return zzc;
    }

    final void zzb(String string) throws IOException {
        zzab zzab2 = this.zzb();
        if (zzab2 == null || zzab2.zzb(this.zzf.zzb())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zza(zzab2.zza, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    final void zzc(String string) throws IOException {
        zzab zzab2 = this.zzb();
        if (zzab2 == null || zzab2.zzb(this.zzf.zzb())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        bundle.putString("delete", "1");
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zza(zzab2.zza, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final String zza(String string, String string2, Bundle bundle) throws IOException {
        bundle.putString("scope", string2);
        bundle.putString("sender", string);
        bundle.putString("subtype", string);
        bundle.putString("appid", this.getId());
        bundle.putString("gmp_app_id", this.zze.getOptions().getApplicationId());
        bundle.putString("gmsv", Integer.toString(this.zzf.zzd()));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", this.zzf.zzb());
        bundle.putString("app_ver_name", this.zzf.zzc());
        bundle.putString("cliv", "fiid-12210000");
        Bundle bundle2 = this.zzg.zza(bundle);
        if (bundle2 == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string3 = bundle2.getString("registration_id");
        if (string3 != null) {
            return string3;
        }
        String string4 = bundle2.getString("unregistered");
        if (string4 != null) {
            return string4;
        }
        String string5 = bundle2.getString("error");
        if ("RST".equals(string5)) {
            this.zzf();
            throw new IOException("INSTANCE_ID_RESET");
        }
        if (string5 != null) {
            throw new IOException(string5);
        }
        String string6 = String.valueOf(bundle2);
        Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string6).length()).append("Unexpected response: ").append(string6).toString(), (Throwable)new Throwable());
        throw new IOException("SERVICE_NOT_AVAILABLE");
    }

    static boolean zze() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    private final synchronized KeyPair zzk() {
        if (this.zzh == null) {
            this.zzh = zzc.zzf("");
        }
        if (this.zzh == null) {
            this.zzh = zzc.zzd("");
        }
        return this.zzh;
    }

    final synchronized void zzf() {
        zzc.zzb();
        this.zzh = null;
        if (this.zzh()) {
            this.zzj();
        }
    }

    final void zzg() {
        zzc.zze("");
        this.zzj();
    }

    private final boolean zzl() {
        Context context = this.zze.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("auto_init")) {
            return sharedPreferences.getBoolean("auto_init", true);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return this.zzm();
    }

    private final boolean zzm() {
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessaging");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Context context = this.zze.getApplicationContext();
            Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
            intent.setPackage(context.getPackageName());
            ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
            return resolveInfo != null && resolveInfo.serviceInfo != null;
        }
    }

    @Hide
    public final synchronized boolean zzh() {
        return this.zzj;
    }

    @Hide
    public final synchronized void zzb(boolean bl) {
        SharedPreferences.Editor editor = this.zze.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
        editor.putBoolean("auto_init", bl);
        editor.apply();
        if (!this.zzj && bl) {
            this.zzi();
        }
        this.zzj = bl;
    }
}

