/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzu;
import com.google.firebase.iid.zzw;
import com.google.firebase.iid.zzy;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzx {
    private static int zza = 0;
    private static PendingIntent zzb;
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> zzc = new SimpleArrayMap();
    private final Context zzd;
    private final zzw zze;
    private Messenger zzf;
    private Messenger zzg;
    private zzi zzh;

    public zzx(Context context, zzw zzw2) {
        this.zzd = context;
        this.zze = zzw2;
        this.zzf = new Messenger((Handler)new zzy(this, Looper.getMainLooper()));
    }

    private final void zza(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader((ClassLoader)new zzi.zza());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof zzi) {
                    this.zzh = (zzi)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzg = (Messenger)parcelable;
                }
            }
            Intent intent2 = (Intent)message.obj;
            zzx zzx2 = this;
            String string = intent2.getAction();
            if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string2 = String.valueOf(string);
                    Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Unexpected response action: ".concat(string2) : new String("Unexpected response action: ")));
                }
                return;
            }
            String string3 = intent2.getStringExtra("registration_id");
            if (string3 == null) {
                string3 = intent2.getStringExtra("unregistered");
            }
            if (string3 == null) {
                zzx2.zza(intent2);
                return;
            }
            Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string3);
            if (!matcher.matches()) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string4 = String.valueOf(string3);
                    Log.d((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Unexpected response string: ".concat(string4) : new String("Unexpected response string: ")));
                }
                return;
            }
            String string5 = matcher.group(1);
            String string6 = matcher.group(2);
            Bundle bundle = intent2.getExtras();
            bundle.putString("registration_id", string6);
            zzx2.zza(string5, bundle);
            return;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Dropping invalid message");
    }

    @Hide
    private static synchronized void zza(Context context, Intent intent) {
        if (zzb == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzb = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"FirebaseInstanceId", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (stringArray.length <= 2 || !"ID".equals(stringArray[1])) {
                String string4 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Unexpected structured response ".concat(string4) : new String("Unexpected structured response ")));
                return;
            }
            String string5 = stringArray[2];
            string = stringArray[3];
            if (string.startsWith(":")) {
                string = string.substring(1);
            }
            this.zza(string5, intent.putExtra("error", string).getExtras());
            return;
        }
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzc;
        synchronized (simpleArrayMap) {
            for (int i = 0; i < this.zzc.size(); ++i) {
                this.zza((String)this.zzc.keyAt(i), intent.getExtras());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string, Bundle bundle) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzc;
        synchronized (simpleArrayMap) {
            TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzc.remove((Object)string);
            if (taskCompletionSource == null) {
                String string2 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for ")));
                return;
            }
            taskCompletionSource.setResult((Object)bundle);
            return;
        }
    }

    final Bundle zza(Bundle bundle) throws IOException {
        if (this.zze.zzd() >= 12000000) {
            Task<Bundle> task = zzk.zza(this.zzd).zzb(1, bundle);
            try {
                return (Bundle)Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string = String.valueOf(exception);
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(22 + String.valueOf(string).length()).append("Error making request: ").append(string).toString());
                }
                if (exception.getCause() instanceof zzu && ((zzu)exception.getCause()).zza() == 4) {
                    return this.zzb(bundle);
                }
                return null;
            }
        }
        return this.zzb(bundle);
    }

    private final Bundle zzb(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zzc(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zzc(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zza() {
        return Integer.toString(zza++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzc(Bundle bundle) throws IOException {
        Bundle bundle2;
        TaskCompletionSource taskCompletionSource;
        String string;
        block26: {
            zzx zzx2;
            Intent intent;
            block27: {
                String string2;
                string = zzx.zza();
                taskCompletionSource = new TaskCompletionSource();
                bundle2 = this.zzc;
                synchronized (bundle2) {
                    this.zzc.put((Object)string, (Object)taskCompletionSource);
                }
                String string3 = string;
                Bundle bundle3 = bundle;
                zzx zzx3 = this;
                if (zzx3.zze.zza() == 0) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (zzx3.zze.zza() == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle3);
                zzx.zza(zzx3.zzd, intent2);
                String string4 = string3;
                intent = intent2;
                zzx2 = zzx3;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)zzx2.zzf);
                if (zzx2.zzg != null || zzx2.zzh != null) {
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (zzx2.zzg != null) {
                            zzx2.zzg.send((Message)string2);
                        } else {
                            zzx2.zzh.zza((Message)string2);
                        }
                        break block26;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block27;
                        Log.d((String)"FirebaseInstanceId", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (zzx2.zze.zza() == 2) {
                zzx2.zzd.sendBroadcast(intent);
            } else {
                zzx2.zzd.startService(intent);
            }
        }
        try {
            bundle2 = (Bundle)Tasks.await((Task)taskCompletionSource.getTask(), (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
            return bundle2;
        }
        catch (InterruptedException | TimeoutException exception) {
            Log.w((String)"FirebaseInstanceId", (String)"No response");
            throw new IOException("TIMEOUT");
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        finally {
            SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzc;
            synchronized (simpleArrayMap) {
                this.zzc.remove((Object)string);
            }
        }
    }

    static /* synthetic */ void zza(zzx zzx2, Message message) {
        zzx2.zza(message);
    }
}

