/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzao;
import com.google.firebase.iid.zzap;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzo;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zzah = TimeUnit.HOURS.toSeconds(8L);
    private static zzao zzai;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledThreadPoolExecutor zzaj;
    private final FirebaseApp zzak;
    private final zzae zzal;
    private final zzo zzam;
    private final zzah zzan = new zzah();
    @GuardedBy(value="this")
    private boolean zzao = false;
    @GuardedBy(value="this")
    private boolean zzap;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp) {
        this(firebaseApp, new zzae(firebaseApp.getApplicationContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzae zzae2) {
        if (zzae.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzai == null) {
                zzai = new zzao(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.zzak = firebaseApp;
            this.zzal = zzae2;
            this.zzam = new zzl(firebaseApp, this, zzae2);
            this.zzap = this.zzm();
            if (this.zzo()) {
                this.zzd();
            }
            return;
        }
    }

    private final void zzd() {
        zzap zzap2 = this.zzg();
        if (zzap2 == null || zzap2.zzj(this.zzal.zzy()) || zzai.zzaf() != null) {
            this.startSync();
        }
    }

    final FirebaseApp zze() {
        return this.zzak;
    }

    final synchronized void zza(boolean bl) {
        this.zzao = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzao) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzah);
        FirebaseInstanceId.zza(new zzaq(this, this.zzal, l2), l);
        this.zzao = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzaj == null) {
                zzaj = new ScheduledThreadPoolExecutor(1);
            }
            zzaj.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzd();
        return FirebaseInstanceId.zzf();
    }

    static String zzf() {
        return zzae.zza(zzai.zzg("").getKeyPair());
    }

    public long getCreationTime() {
        return zzai.zzg("").getCreationTime();
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        this.zza("*", "*", bundle);
        this.zzk();
    }

    @Nullable
    public String getToken() {
        zzap zzap2 = this.zzg();
        if (zzap2 == null || zzap2.zzj(this.zzal.zzy())) {
            this.startSync();
        }
        if (zzap2 != null) {
            return zzap2.zzcu;
        }
        return null;
    }

    @Nullable
    final zzap zzg() {
        return zzai.zzb("", zzae.zza(this.zzak), "*");
    }

    final String zzh() throws IOException {
        return this.getToken(zzae.zza(this.zzak), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        zzap zzap2 = zzai.zzb("", string, string2 = FirebaseInstanceId.zzd(string2));
        if (zzap2 != null && !zzap2.zzj(this.zzal.zzy())) {
            return zzap2.zzcu;
        }
        String string3 = string2;
        return this.zzan.zza(string, string3, new zzk(this, string, string3));
    }

    private static <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw new IOException(throwable);
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        this.zza(string, string2, bundle);
        zzai.zzc("", string, string2);
    }

    public final synchronized void zza(String string) {
        zzai.zza(string);
        this.startSync();
    }

    static zzao zzi() {
        return zzai;
    }

    final void zzb(String string) throws IOException {
        zzap zzap2 = this.zzg();
        if (zzap2 == null || zzap2.zzj(this.zzal.zzy())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zza(zzap2.zzcu, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    final void zzc(String string) throws IOException {
        zzap zzap2 = this.zzg();
        if (zzap2 == null || zzap2.zzj(this.zzal.zzy())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        bundle.putString("delete", "1");
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zza(zzap2.zzcu, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final String zza(String string, String string2, Bundle bundle) throws IOException {
        return ((zzl)this.zzam).zza(string, string2, bundle);
    }

    static boolean zzj() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zzk() {
        zzai.zzag();
        if (this.zzo()) {
            this.startSync();
        }
    }

    final void zzl() {
        zzai.zzh("");
        this.startSync();
    }

    private final boolean zzm() {
        Context context = this.zzak.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("auto_init")) {
            return sharedPreferences.getBoolean("auto_init", true);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return this.zzn();
    }

    private final boolean zzn() {
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessaging");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Context context = this.zzak.getApplicationContext();
            Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
            intent.setPackage(context.getPackageName());
            ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
            return resolveInfo != null && resolveInfo.serviceInfo != null;
        }
    }

    @VisibleForTesting
    public final synchronized boolean zzo() {
        return this.zzap;
    }

    @VisibleForTesting
    public final synchronized void zzb(boolean bl) {
        SharedPreferences.Editor editor = this.zzak.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
        editor.putBoolean("auto_init", bl);
        editor.apply();
        if (!this.zzap && bl) {
            this.zzd();
        }
        this.zzap = bl;
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final /* synthetic */ String zza(String string, String string2) throws IOException {
        String string3 = FirebaseInstanceId.zza(this.zzam.zzb(string, string2));
        zzai.zza("", string, string2, string3, this.zzal.zzy());
        return string3;
    }
}

