/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzao;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzv;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

final class zzan {
    private static int zzby = 0;
    private static PendingIntent zzck;
    @GuardedBy(value="responseCallbacks")
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> zzcl = new SimpleArrayMap();
    private final Context zzz;
    private final zzah zzao;
    private Messenger zzcm;
    private Messenger zzcn;
    private zzi zzco;

    public zzan(Context context, zzah zzah2) {
        this.zzz = context;
        this.zzao = zzah2;
        this.zzcm = new Messenger((Handler)new zzao(this, Looper.getMainLooper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzb(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader((ClassLoader)new zzi.zza());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof zzi) {
                    this.zzco = (zzi)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzcn = (Messenger)parcelable;
                }
            }
            Intent intent2 = (Intent)message.obj;
            zzan zzan2 = this;
            String string = intent2.getAction();
            if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
                if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) return;
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Unexpected response action: ".concat(string2) : new String("Unexpected response action: ")));
                return;
            }
            String string3 = intent2.getStringExtra("registration_id");
            if (string3 == null) {
                string3 = intent2.getStringExtra("unregistered");
            }
            if (string3 == null) {
                Intent intent3 = intent2;
                zzan zzan3 = zzan2;
                String string4 = intent3.getStringExtra("error");
                if (string4 == null) {
                    String string5 = String.valueOf(intent3.getExtras());
                    Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                    return;
                }
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string6 = String.valueOf(string4);
                    Log.d((String)"FirebaseInstanceId", (String)(string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error ")));
                }
                if (string4.startsWith("|")) {
                    String[] stringArray = string4.split("\\|");
                    if (stringArray.length <= 2 || !"ID".equals(stringArray[1])) {
                        String string7 = String.valueOf(string4);
                        Log.w((String)"FirebaseInstanceId", (String)(string7.length() != 0 ? "Unexpected structured response ".concat(string7) : new String("Unexpected structured response ")));
                        return;
                    }
                    String string8 = stringArray[2];
                    string4 = stringArray[3];
                    if (string4.startsWith(":")) {
                        string4 = string4.substring(1);
                    }
                    zzan3.zza(string8, intent3.putExtra("error", string4).getExtras());
                    return;
                }
                SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = zzan3.zzcl;
                synchronized (simpleArrayMap) {
                    int n = 0;
                    while (n < zzan3.zzcl.size()) {
                        zzan3.zza((String)zzan3.zzcl.keyAt(n), intent3.getExtras());
                        ++n;
                    }
                    return;
                }
            }
            Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string3);
            if (matcher.matches()) {
                String string9 = matcher.group(1);
                String string10 = matcher.group(2);
                Bundle bundle = intent2.getExtras();
                bundle.putString("registration_id", string10);
                zzan2.zza(string9, bundle);
                return;
            }
            if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) return;
            String string11 = String.valueOf(string3);
            Log.d((String)"FirebaseInstanceId", (String)(string11.length() != 0 ? "Unexpected response string: ".concat(string11) : new String("Unexpected response string: ")));
            return;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Dropping invalid message");
    }

    private static synchronized void zza(Context context, Intent intent) {
        if (zzck == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzck = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string, Bundle bundle) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzcl;
        synchronized (simpleArrayMap) {
            TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzcl.remove((Object)string);
            if (taskCompletionSource == null) {
                String string2 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for ")));
                return;
            }
            taskCompletionSource.setResult((Object)bundle);
            return;
        }
    }

    final Bundle zzc(Bundle bundle) throws IOException {
        if (this.zzao.zzz() >= 12000000) {
            Task<Bundle> task = zzv.zzc(this.zzz).zzb(1, bundle);
            try {
                return (Bundle)Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string = String.valueOf(exception);
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(22 + String.valueOf(string).length()).append("Error making request: ").append(string).toString());
                }
                if (exception.getCause() instanceof zzaf && ((zzaf)exception.getCause()).getErrorCode() == 4) {
                    return this.zzd(bundle);
                }
                return null;
            }
        }
        return this.zzd(bundle);
    }

    private final Bundle zzd(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zze(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zze(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zzab() {
        return Integer.toString(zzby++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zze(Bundle bundle) throws IOException {
        Bundle bundle2;
        TaskCompletionSource taskCompletionSource;
        String string;
        block26: {
            zzan zzan2;
            Intent intent;
            block27: {
                String string2;
                string = zzan.zzab();
                taskCompletionSource = new TaskCompletionSource();
                bundle2 = this.zzcl;
                synchronized (bundle2) {
                    this.zzcl.put((Object)string, (Object)taskCompletionSource);
                }
                String string3 = string;
                Bundle bundle3 = bundle;
                zzan zzan3 = this;
                if (zzan3.zzao.zzw() == 0) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (zzan3.zzao.zzw() == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle3);
                zzan.zza(zzan3.zzz, intent2);
                String string4 = string3;
                intent = intent2;
                zzan2 = zzan3;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)zzan2.zzcm);
                if (zzan2.zzcn != null || zzan2.zzco != null) {
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (zzan2.zzcn != null) {
                            zzan2.zzcn.send((Message)string2);
                        } else {
                            zzan2.zzco.send((Message)string2);
                        }
                        break block26;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block27;
                        Log.d((String)"FirebaseInstanceId", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (zzan2.zzao.zzw() == 2) {
                zzan2.zzz.sendBroadcast(intent);
            } else {
                zzan2.zzz.startService(intent);
            }
        }
        try {
            bundle2 = (Bundle)Tasks.await((Task)taskCompletionSource.getTask(), (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
            return bundle2;
        }
        catch (InterruptedException | TimeoutException exception) {
            Log.w((String)"FirebaseInstanceId", (String)"No response");
            throw new IOException("TIMEOUT");
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        finally {
            SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzcl;
            synchronized (simpleArrayMap) {
                this.zzcl.remove((Object)string);
            }
        }
    }

    static /* synthetic */ void zza(zzan zzan2, Message message) {
        zzan2.zzb(message);
    }
}

