/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.internal.firebase_messaging.zzh;
import com.google.firebase.iid.zza;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzt;
import com.google.firebase.iid.zzu;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;

final class zzs {
    zzs() {
    }

    @WorkerThread
    final zzt zzb(Context context, String string) throws zzu {
        zzt zzt2 = this.zzd(context, string);
        if (zzt2 != null) {
            return zzt2;
        }
        return this.zzc(context, string);
    }

    @WorkerThread
    final zzt zzc(Context context, String string) {
        zzt zzt2 = new zzt(zza.zzb(), System.currentTimeMillis());
        try {
            zzt zzt3 = this.zzd(context, string);
            if (zzt3 != null) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    Log.d((String)"FirebaseInstanceId", (String)"Loaded key after generating new one, using loaded one");
                }
                return zzt3;
            }
        }
        catch (zzu zzu2) {}
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Generated new key");
        }
        zzs.zza(context, string, zzt2);
        this.zzb(context, string, zzt2);
        return zzt2;
    }

    static void zza(Context context) {
        for (File file : zzs.zzb(context).listFiles()) {
            if (!file.getName().startsWith("com.google.InstanceId")) continue;
            file.delete();
        }
    }

    @Nullable
    private final zzt zzd(Context context, String string) throws zzu {
        zzt zzt2;
        Object var3_3 = null;
        try {
            zzt2 = this.zze(context, string);
            if (zzt2 != null) {
                this.zzb(context, string, zzt2);
                return zzt2;
            }
        }
        catch (zzu zzu2) {
            // empty catch block
        }
        try {
            String string2 = string;
            Context context2 = context;
            zzt2 = zzs.zza(context2.getSharedPreferences("com.google.android.gms.appid", 0), string2);
            if (zzt2 != null) {
                zzs.zza(context, string, zzt2);
                return zzt2;
            }
        }
        catch (zzu zzu3) {
            // empty catch block
        }
        if (var3_3 != null) {
            throw var3_3;
        }
        return null;
    }

    private static KeyPair zza(String string, String string2) throws zzu {
        byte[] byArray;
        byte[] byArray2;
        try {
            byArray2 = Base64.decode((String)string, (int)8);
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new zzu(illegalArgumentException);
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string3 = String.valueOf(generalSecurityException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(19 + String.valueOf(string3).length()).append("Invalid key stored ").append(string3).toString());
            throw new zzu(generalSecurityException);
        }
    }

    @Nullable
    private final zzt zze(Context context, String string) throws zzu {
        File file = zzs.zzf(context, string);
        if (!file.exists()) {
            return null;
        }
        try {
            return zzs.zza(file);
        }
        catch (IOException iOException) {
            String string2;
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                string2 = String.valueOf(iOException);
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to read key from file, retrying: ").append(string2).toString());
            }
            try {
                return zzs.zza(file);
            }
            catch (IOException iOException2) {
                string2 = String.valueOf(iOException2);
                Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("IID file exists, but failed to read from it: ").append(string2).toString());
                throw new zzu(iOException2);
            }
        }
    }

    private static void zza(Context context, String string, zzt zzt2) {
        try {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Writing key to properties file");
            }
            File file = zzs.zzf(context, string);
            file.createNewFile();
            Properties properties = new Properties();
            properties.setProperty("pub", zzt.zza(zzt2));
            properties.setProperty("pri", zzt.zzb(zzt2));
            properties.setProperty("cre", String.valueOf(zzt.zzc(zzt2)));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                properties.store(fileOutputStream, null);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    zzs.zza(throwable, fileOutputStream);
                    throw throwable4;
                }
            }
            zzs.zza(null, fileOutputStream);
            return;
        }
        catch (IOException iOException) {
            String string2 = String.valueOf(iOException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string2).length()).append("Failed to write key: ").append(string2).toString());
            return;
        }
    }

    private static File zzb(Context context) {
        File file = ContextCompat.getNoBackupFilesDir((Context)context);
        if (file != null && file.isDirectory()) {
            return file;
        }
        Log.w((String)"FirebaseInstanceId", (String)"noBackupFilesDir doesn't exist, using regular files directory instead");
        return context.getFilesDir();
    }

    private static File zzf(Context context, String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string2 = "com.google.InstanceId.properties";
        } else {
            try {
                String string3 = Base64.encodeToString((byte[])string.getBytes("UTF-8"), (int)11);
                string2 = new StringBuilder(33 + String.valueOf(string3).length()).append("com.google.InstanceId_").append(string3).append(".properties").toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }
        return new File(zzs.zzb(context), string2);
    }

    @Nullable
    private static zzt zza(File file) throws zzu, IOException {
        zzt zzt2;
        String string;
        String string2;
        Serializable serializable;
        Throwable throwable;
        FileInputStream fileInputStream;
        block7: {
            fileInputStream = new FileInputStream(file);
            throwable = null;
            serializable = new Properties();
            ((Properties)serializable).load(fileInputStream);
            string2 = ((Properties)serializable).getProperty("pub");
            string = ((Properties)serializable).getProperty("pri");
            if (string2 != null && string != null) break block7;
            zzs.zza(null, fileInputStream);
            return null;
        }
        try {
            long l;
            KeyPair keyPair = zzs.zza(string2, string);
            try {
                l = Long.parseLong(((Properties)serializable).getProperty("cre"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new zzu(numberFormatException);
            }
            zzt2 = new zzt(keyPair, l);
        }
        catch (Throwable throwable2) {
            try {
                serializable = throwable2;
                throwable = throwable2;
                throw serializable;
            }
            catch (Throwable throwable3) {
                zzs.zza(throwable, fileInputStream);
                throw throwable3;
            }
        }
        zzs.zza(null, fileInputStream);
        return zzt2;
    }

    @Nullable
    private static zzt zza(SharedPreferences sharedPreferences, String string) throws zzu {
        String string2 = sharedPreferences.getString(zzaq.zzb(string, "|P|"), null);
        String string3 = sharedPreferences.getString(zzaq.zzb(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        KeyPair keyPair = zzs.zza(string2, string3);
        long l = zzs.zzb(sharedPreferences, string);
        return new zzt(keyPair, l);
    }

    private final void zzb(Context context, String string, zzt zzt2) {
        zzt zzt3;
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.appid", 0);
        try {
            zzt3 = zzs.zza(sharedPreferences, string);
            if (zzt2.equals(zzt3)) {
                return;
            }
        }
        catch (zzu zzu2) {}
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Writing key to shared preferences");
        }
        zzt3 = sharedPreferences.edit();
        zzt3.putString(zzaq.zzb(string, "|P|"), zzt.zza(zzt2));
        zzt3.putString(zzaq.zzb(string, "|K|"), zzt.zzb(zzt2));
        zzt3.putString(zzaq.zzb(string, "cre"), String.valueOf(zzt.zzc(zzt2)));
        zzt3.commit();
    }

    private static long zzb(SharedPreferences sharedPreferences, String string) {
        String string2 = sharedPreferences.getString(zzaq.zzb(string, "cre"), null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    private static /* synthetic */ void zza(Throwable throwable, FileOutputStream fileOutputStream) {
        if (throwable != null) {
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable2) {
                zzh.zza(throwable, throwable2);
                return;
            }
        }
        fileOutputStream.close();
    }

    private static /* synthetic */ void zza(Throwable throwable, FileInputStream fileInputStream) {
        if (throwable != null) {
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable2) {
                zzh.zza(throwable, throwable2);
                return;
            }
        }
        fileInputStream.close();
    }
}

