/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzv;
import com.google.firebase.iid.zzw;
import com.google.firebase.iid.zzy;
import com.google.firebase.iid.zzz;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzx
implements ServiceConnection {
    @GuardedBy(value="this")
    int state = 0;
    final Messenger zzbq = new Messenger(new Handler(Looper.getMainLooper(), (Handler.Callback)new zzy(this)));
    zzac zzbr;
    @GuardedBy(value="this")
    final Queue<zzae<?>> zzbs = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzae<?>> zzbt = new SparseArray();
    final /* synthetic */ zzv zzbu;

    private zzx(zzv zzv2) {
        this.zzbu = zzv2;
    }

    final synchronized boolean zzb(zzae zzae2) {
        switch (this.state) {
            case 0: {
                this.zzbs.add(zzae2);
                zzx zzx2 = this;
                Preconditions.checkState((zzx2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzx2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzv.zza(zzx2.zzbu), intent, (ServiceConnection)zzx2, 1)) {
                    zzx2.zza(0, "Unable to bind to service");
                } else {
                    zzv.zzb(zzx2.zzbu).schedule(new zzz(zzx2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzbs.add(zzae2);
                return true;
            }
            case 2: {
                this.zzbs.add(zzae2);
                this.zzs();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzae zzae2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzx zzx2 = this;
        synchronized (zzx2) {
            zzae2 = (zzae)this.zzbt.get(n);
            if (zzae2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzbt.remove(n);
            this.zzt();
        }
        Bundle bundle = message.getData();
        zzae zzae3 = zzae2;
        if (bundle.getBoolean("unsupported", false)) {
            zzae3.zza(new zzaf(4, "Not supported by GmsCore"));
        } else {
            zzae3.zzb(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zza(0, "Null service connection");
            return;
        }
        try {
            this.zzbr = new zzac(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zza(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzs();
    }

    private final void zzs() {
        zzv.zzb(this.zzbu).execute(new zzaa(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zza(2, "Service disconnected");
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                ConnectionTracker.getInstance().unbindService(zzv.zza(this.zzbu), (ServiceConnection)this);
                zzaf zzaf2 = new zzaf(n, string);
                zzx zzx2 = this;
                Iterator iterator = zzx2.zzbs.iterator();
                while (iterator.hasNext()) {
                    ((zzae)iterator.next()).zza(zzaf2);
                }
                zzx2.zzbs.clear();
                for (int i = 0; i < zzx2.zzbt.size(); ++i) {
                    ((zzae)zzx2.zzbt.valueAt(i)).zza(zzaf2);
                }
                zzx2.zzbt.clear();
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzt() {
        if (this.state == 2 && this.zzbs.isEmpty() && this.zzbt.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            ConnectionTracker.getInstance().unbindService(zzv.zza(this.zzbu), (ServiceConnection)this);
        }
    }

    final synchronized void zzu() {
        if (this.state == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzae zzae2 = (zzae)this.zzbt.get(n);
        if (zzae2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzbt.remove(n);
            zzae2.zza(new zzaf(3, "Timed out waiting for response"));
            this.zzt();
        }
    }

    /* synthetic */ zzx(zzv zzv2, zzw zzw2) {
        this(zzv2);
    }
}

