/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzaj;
import com.google.firebase.iid.zzak;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzac
implements ServiceConnection {
    @GuardedBy(value="this")
    int state = 0;
    final Messenger zzbu = new Messenger(new Handler(Looper.getMainLooper(), (Handler.Callback)new zzad(this)));
    zzah zzbv;
    @GuardedBy(value="this")
    final Queue<zzaj<?>> zzbw = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzaj<?>> zzbx = new SparseArray();
    final /* synthetic */ zzaa zzby;

    private zzac(zzaa zzaa2) {
        this.zzby = zzaa2;
    }

    final synchronized boolean zzb(zzaj zzaj2) {
        switch (this.state) {
            case 0: {
                this.zzbw.add(zzaj2);
                zzac zzac2 = this;
                Preconditions.checkState((zzac2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzac2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzaa.zza(zzac2.zzby), intent, (ServiceConnection)zzac2, 1)) {
                    zzac2.zza(0, "Unable to bind to service");
                } else {
                    zzaa.zzb(zzac2.zzby).schedule(new zzae(zzac2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzbw.add(zzaj2);
                return true;
            }
            case 2: {
                this.zzbw.add(zzaj2);
                this.zzx();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzaj zzaj2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzac zzac2 = this;
        synchronized (zzac2) {
            zzaj2 = (zzaj)this.zzbx.get(n);
            if (zzaj2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzbx.remove(n);
            this.zzy();
        }
        Bundle bundle = message.getData();
        zzaj zzaj3 = zzaj2;
        if (bundle.getBoolean("unsupported", false)) {
            zzaj3.zza(new zzak(4, "Not supported by GmsCore"));
        } else {
            zzaj3.zzb(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zza(0, "Null service connection");
            return;
        }
        try {
            this.zzbv = new zzah(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zza(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzx();
    }

    private final void zzx() {
        zzaa.zzb(this.zzby).execute(new zzaf(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zza(2, "Service disconnected");
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                ConnectionTracker.getInstance().unbindService(zzaa.zza(this.zzby), (ServiceConnection)this);
                zzak zzak2 = new zzak(n, string);
                zzac zzac2 = this;
                Iterator iterator = zzac2.zzbw.iterator();
                while (iterator.hasNext()) {
                    ((zzaj)iterator.next()).zza(zzak2);
                }
                zzac2.zzbw.clear();
                for (int i = 0; i < zzac2.zzbx.size(); ++i) {
                    ((zzaj)zzac2.zzbx.valueAt(i)).zza(zzak2);
                }
                zzac2.zzbx.clear();
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzy() {
        if (this.state == 2 && this.zzbw.isEmpty() && this.zzbx.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            ConnectionTracker.getInstance().unbindService(zzaa.zza(this.zzby), (ServiceConnection)this);
        }
    }

    final synchronized void zzz() {
        if (this.state == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzaj zzaj2 = (zzaj)this.zzbx.get(n);
        if (zzaj2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzbx.remove(n);
            zzaj2.zza(new zzak(3, "Timed out waiting for response"));
            this.zzy();
        }
    }

    /* synthetic */ zzac(zzaa zzaa2, zzab zzab2) {
        this(zzaa2);
    }
}

