/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzam;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzaw;
import com.google.firebase.iid.zzay;
import com.google.firebase.iid.zzaz;
import java.io.IOException;

final class zzax
implements Runnable {
    private final long zzde;
    private final PowerManager.WakeLock zzdf;
    private final FirebaseInstanceId zzdg;
    private final zzam zzak;
    private final zzaz zzan;

    @VisibleForTesting
    zzax(FirebaseInstanceId firebaseInstanceId, zzam zzam2, zzaz zzaz2, long l) {
        this.zzdg = firebaseInstanceId;
        this.zzak = zzam2;
        this.zzan = zzaz2;
        this.zzde = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzdf = powerManager.newWakeLock(1, "fiid-sync");
        this.zzdf.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zzdf.acquire();
        try {
            this.zzdg.zza(true);
            if (!this.zzdg.zzm()) {
                this.zzdg.zza(false);
                return;
            }
            if (!this.zzan()) {
                new zzay(this).zzao();
                return;
            }
            if (this.zzal() && this.zzam() && this.zzan.zzc(this.zzdg)) {
                this.zzdg.zza(false);
            } else {
                this.zzdg.zza(this.zzde);
            }
            return;
        }
        finally {
            this.zzdf.release();
        }
    }

    @VisibleForTesting
    private final boolean zzal() {
        try {
            if (!this.zzdg.zzn()) {
                this.zzdg.zzo();
            }
            return true;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Build channel failed: ".concat(string) : new String("Build channel failed: ")));
            return false;
        }
    }

    @VisibleForTesting
    private final boolean zzam() {
        zzaw zzaw2 = this.zzdg.zzi();
        if (zzaw2 != null && !zzaw2.zzj(this.zzak.zzac())) {
            return true;
        }
        try {
            String string = this.zzdg.zzj();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzaw2 == null || zzaw2 != null && !string.equals(zzaw2.zzbn)) {
                String string2;
                String string3 = string2 = string;
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
                intent.putExtra("token", string3);
                zzau.zzc(context, intent);
                Intent intent2 = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                zzau.zzb(context, intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    final Context getContext() {
        return this.zzdg.zzg().getApplicationContext();
    }

    final boolean zzan() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

