/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.util.Base64;
import android.util.Log;
import androidx.legacy.content.WakefulBroadcastReceiver;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzan;
import com.google.firebase.iid.zzay;
import javax.annotation.concurrent.GuardedBy;

public final class FirebaseInstanceIdReceiver
extends WakefulBroadcastReceiver {
    @GuardedBy(value="FirebaseInstanceIdReceiver.class")
    private static zzay zza;

    public final void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        Parcelable parcelable = intent.getParcelableExtra("wrapped_intent");
        Intent intent2 = parcelable instanceof Intent ? (Intent)parcelable : null;
        if (intent2 != null) {
            this.zza(context, intent2);
            return;
        }
        this.zza(context, intent);
    }

    private final void zza(Context context, Intent intent) {
        int n;
        String string;
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ("google.com/iid".equals(string = intent.getStringExtra("from"))) {
            Intent intent2 = intent;
            String string2 = intent2.getStringExtra("CMD");
            if (string2 != null) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string3 = String.valueOf(intent2.getExtras());
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Received command: ").append(string2).append(" - ").append(string3).toString());
                }
                if ("RST".equals(string2) || "RST_FULL".equals(string2)) {
                    FirebaseInstanceId.getInstance().zze();
                } else if ("SYNC".equals(string2)) {
                    FirebaseInstanceId.getInstance().zzg();
                }
            }
            n = -1;
        } else {
            String string4 = intent.getStringExtra("gcm.rawData64");
            if (string4 != null) {
                intent.putExtra("rawData", Base64.decode((String)string4, (int)0));
                intent.removeExtra("gcm.rawData64");
            }
            n = FirebaseInstanceIdReceiver.zza((BroadcastReceiver)this, context, intent);
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(n);
        }
    }

    @ShowFirstParty
    @SuppressLint(value={"InlinedApi"})
    public static int zza(BroadcastReceiver broadcastReceiver, Context context, Intent intent) {
        boolean bl;
        boolean bl2 = PlatformVersion.isAtLeastO() && context.getApplicationInfo().targetSdkVersion >= 26;
        boolean bl3 = bl = (intent.getFlags() & 0x10000000) != 0;
        if (bl2 && !bl) {
            return FirebaseInstanceIdReceiver.zzb(broadcastReceiver, context, intent);
        }
        int n = zzan.zza().zza(context, intent);
        if (PlatformVersion.isAtLeastO() && n == 402) {
            FirebaseInstanceIdReceiver.zzb(broadcastReceiver, context, intent);
            return 403;
        }
        return n;
    }

    private static int zzb(BroadcastReceiver broadcastReceiver, Context context, Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Binding to service");
        }
        if (broadcastReceiver.isOrderedBroadcast()) {
            broadcastReceiver.setResultCode(-1);
        }
        FirebaseInstanceIdReceiver.zza(context, "com.google.firebase.MESSAGING_EVENT").zza(intent, broadcastReceiver.goAsync());
        return -1;
    }

    private static synchronized zzay zza(Context context, String string) {
        if (zza == null) {
            zza = new zzay(context, string);
        }
        return zza;
    }
}

