/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.firebase_messaging.zze;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzu;
import com.google.firebase.iid.zzw;
import com.google.firebase.iid.zzx;
import com.google.firebase.iid.zzy;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzv
implements ServiceConnection {
    @GuardedBy(value="this")
    int zza = 0;
    final Messenger zzb = new Messenger((Handler)new zze(Looper.getMainLooper(), new zzy(this)));
    zzac zzc;
    @GuardedBy(value="this")
    final Queue<zzae<?>> zzd = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzae<?>> zze = new SparseArray();
    final /* synthetic */ zzu zzf;

    private zzv(zzu zzu2) {
        this.zzf = zzu2;
    }

    final synchronized boolean zza(zzae<?> zzae2) {
        switch (this.zza) {
            case 0: {
                this.zzd.add(zzae2);
                zzv zzv2 = this;
                Preconditions.checkState((zzv2.zza == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzv2.zza = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzu.zza(zzv2.zzf), intent, (ServiceConnection)zzv2, 1)) {
                    zzv2.zza(0, "Unable to bind to service");
                } else {
                    zzu.zzb(zzv2.zzf).schedule(new zzx(zzv2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzd.add(zzae2);
                return true;
            }
            case 2: {
                this.zzd.add(zzae2);
                this.zzc();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.zza;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzae zzae2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzv zzv2 = this;
        synchronized (zzv2) {
            zzae2 = (zzae)this.zze.get(n);
            if (zzae2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zze.remove(n);
            this.zza();
        }
        Bundle bundle = message.getData();
        zzae zzae3 = zzae2;
        if (bundle.getBoolean("unsupported", false)) {
            zzae3.zza(new zzad(4, "Not supported by GmsCore"));
        } else {
            zzae3.zza(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zza(0, "Null service connection");
            return;
        }
        try {
            this.zzc = new zzac(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zza(0, remoteException.getMessage());
            return;
        }
        this.zza = 2;
        this.zzc();
    }

    private final void zzc() {
        zzu.zzb(this.zzf).execute(new zzaa(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zza(2, "Service disconnected");
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.zza) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.zza = 4;
                ConnectionTracker.getInstance().unbindService(zzu.zza(this.zzf), (ServiceConnection)this);
                zzad zzad2 = new zzad(n, string);
                zzv zzv2 = this;
                Iterator iterator = zzv2.zzd.iterator();
                while (iterator.hasNext()) {
                    ((zzae)iterator.next()).zza(zzad2);
                }
                zzv2.zzd.clear();
                for (int i = 0; i < zzv2.zze.size(); ++i) {
                    ((zzae)zzv2.zze.valueAt(i)).zza(zzad2);
                }
                zzv2.zze.clear();
                return;
            }
            case 3: {
                this.zza = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.zza;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zza() {
        if (this.zza == 2 && this.zzd.isEmpty() && this.zze.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.zza = 3;
            ConnectionTracker.getInstance().unbindService(zzu.zza(this.zzf), (ServiceConnection)this);
        }
    }

    final synchronized void zzb() {
        if (this.zza == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzae zzae2 = (zzae)this.zze.get(n);
        if (zzae2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zze.remove(n);
            zzae2.zza(new zzad(3, "Timed out waiting for response"));
            this.zza();
        }
    }

    /* synthetic */ zzv(zzu zzu2, zzw zzw2) {
        this(zzu2);
    }
}

